package com.clx.performance.model.vehiclewarn;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 预警范围
* @Date: 2024/05/06 15:21:27
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class VehicleWarnRang  implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Integer warnConfigId;                   //预警配置id
    private String warnName;                        //预警名称
    private Integer warnRang;                       //预警屏蔽范围：1运单 2货单 3全部
    private String orderNo;                         //货单编号
    private String childNo;                         //运单编号
    private LocalDateTime warnEndTime;              //预警屏蔽结束时间
    private Integer status;                         //状态：1有效 2无效
    private String createBy;                        //创建人
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }
}