package com.clx.performance.controller.pc.vehiclewarn;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.vehiclewarn.*;
import com.clx.performance.service.vehiclewarn.VehicleWarnUserService;
import com.clx.performance.vo.pc.vehiclewarn.VehicleWarnUserVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;


@Slf4j
@RestController
@Validated
@Api(tags = "车辆预警-预警通知人员")
@RequestMapping(value="/pc/owner/vehicleWarnUser")
public class VehicleWarnUserController {

    @Autowired
    private VehicleWarnUserService vehicleWarnUserService;

    @ApiOperation(value = "新增人员", notes = "<br>By:艾庆国")
    @PostMapping("/saveUser")
    @UnitCovert(result = false)
    public Result<Void> saveUser(@RequestBody @Validated VehicleWarnUserAddParam param) {

        vehicleWarnUserService.saveUser(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新用户", notes = "<br>By:艾庆国")
    @PostMapping("/updateUser")
    public Result<Void> updateUser(@RequestBody @Validated VehicleWarnUserUpdateParam param) {
        vehicleWarnUserService.updateUser(param);
        return Result.ok();
    }

    @ApiOperation(value = "更新通知配置", notes = "<br>By:艾庆国")
    @PostMapping("/updateConfig")
    public Result<Void> updateConfig(@RequestBody @Validated VehicleWarnUserConfigUpdateParam param) {

        vehicleWarnUserService.updateConfig(param);
        return Result.ok();
    }

    @ApiOperation(value = "删除用户", notes = "<br>By:艾庆国")
    @PostMapping("/deleteUser")
    public Result<Void> deleteUser(@RequestBody @Validated VehicleWarnUserDeleteParam param) {
        vehicleWarnUserService.deleteUser(param);
        return Result.ok();
    }

    @ApiOperation(value = "获取人员信息",notes = "<br>By:艾庆国")
    @GetMapping("/getUser")
    public Result<VehicleWarnUserVO> getUser(@NotNull(message = "id不能为空") @Validated Integer id) {
        return Result.ok(vehicleWarnUserService.getUser(id));
    }

    @ApiOperation(value = "分页搜索人员列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageUser")
    public Result<PageData<VehicleWarnUserVO>> pageUser(@RequestBody @Validated PageVehicleWarnUserParam param) {
        IPage<VehicleWarnUserVO> page = vehicleWarnUserService.pageUser(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
