package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;


@Getter
@AllArgsConstructor
public enum ResultEnum implements com.msl.common.enums.ResultEnum {



    /**
     * 系统
     */
    SIGN_NULL(1001, "签名不存在"),
    SIGN_ERROR(1002, "签名错误"),
    TIMESTAMP_ERROR(1003, "请求不在时间范围内"),
    INCREMENT_ERROR(1004, "编码生成失败"),
    HTTP_ERROR(1005, "HTTP请求失败"),
    LOCK_ERROR(1006,"加锁失败"),
    TRY_LOCK_ERROR(1007,"操作频繁,请稍后重试"),
    FEIGN_ERROR(1008, "服务调用失败"),
    PARAM_ERROR(1009, "参数缺失"),
    DATA_ERROR(1010, "数据错误"),

    /**
     * 通用
     */
    FILE_LIMIT_ERROR(1104, "文件过大"),
    REPEAT_OPERATION(1105, "重复操作"),
    DATA_NOT_FIND(1106, "数据不存在"),
    DATA_REPEAT(1107, "数据重复"),


    VEHICLE_WARN_USER_EXIST(1201, "联系方式已存在"),
    VEHICLE_WARN_CONFIG_EXIST(1201, "配置名称已存在"),



    ;
    private final int code;
    private final String msg;
}
