package com.clx.performance.controller.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.mapper.OrderGoodsMapper;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.param.app.AppGoodsOrderSearchParam;
import com.clx.performance.param.app.OrderGoodsListPageParam;
import com.clx.performance.service.OrderGoodsService;
import com.clx.performance.service.OrderGoodsTruckBindService;
import com.clx.performance.vo.app.OrderGoodsAPPVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName GoodsOrderController
 * @Description
 * @Author kavin
 * @Date 2023/9/17 17:16
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping("/app/goodsOrder")
@Validated
@AllArgsConstructor
@Api(tags = "APP-货单")
public class AppGoodsOrderController {

    private final OrderGoodsService orderGoodsService;

    private final OrderGoodsTruckBindService orderGoodsTruckBindService;


    @ApiOperation(value = "查看货单详情", notes = "<br>By:胡宇帆")
    @GetMapping("/getOrderGoodsInfo")
    @UnitCovert(param = false)
    public Result<OrderGoodsVO> getOrderGoodsInfo(@Validated @RequestParam String orderGoodsNo) {
        return Result.ok(orderGoodsService.getOrderGoodsInfoByOrderGoodsNoForAPP(orderGoodsNo));
    }

    @ApiOperation(value = "APP首页货单列表", notes = "<br>By:胡宇帆")
    @PostMapping("/indexOrderGoodsList")
    @UnitCovert(param = false)
    public Result<PageData<OrderGoodsAPPVO>> indexOrderGoodsList(@RequestBody OrderGoodsListPageParam orderGoodsListPageParam) {
        IPage<OrderGoodsAPPVO> page = orderGoodsService.indexOrderGoodsList(orderGoodsListPageParam);

        return Result.page(page.getRecords(), page.getTotal(), page.getPages());

    }

    @ApiOperation(value = "APP首页搜索", notes = "<br>By:胡宇帆")
    @PostMapping("/indexOrderGoodsListSearch")
    @UnitCovert(param = false)
    public Result<PageData<OrderGoodsAPPVO>> indexOrderGoodsListSearch(@RequestBody AppGoodsOrderSearchParam param) {
        IPage<OrderGoodsAPPVO> page = orderGoodsService.indexOrderGoodsListSearch(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @ApiOperation(value = "司机端无接单位置上报", notes = "<br>By:胡宇帆")
    @GetMapping("/getCancelOrderGoods")
    public Result<List<OrderGoodsAPPVO>> getCancelOrderGoods(@RequestParam(value = "userNo") Long userNo) {
        return Result.ok(orderGoodsTruckBindService.getCancelOrderGoods(userNo));
    }
}
