package com.clx.performance.feign;

import com.clx.performance.vo.pc.child.OrderChildLineStatisticsVO;
import com.msl.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@FeignClient(name = "clx-performance",configuration = PerformanceClientConfiguration.class)
public interface OrderChildFeign {


    /**
     * 线路运单统计
     */
    @RequestMapping(value = "clx-performance/feign/orderChild/lineStatistics", method = RequestMethod.GET)
    Result<OrderChildLineStatisticsVO> lineStatistics(@RequestParam @NotNull(message = "发货地址不可为空") Integer sendSystemAddressId,
                                              @RequestParam @NotNull(message = "收货货地不可为空") Integer receiveSystemAddressId);


    @RequestMapping(value = "clx-performance/feign/orderChild/syncLastTruck", method = RequestMethod.GET)
    Result<?> syncLastTruck(@RequestParam("orderNo") @NotBlank(message = "订单编号不能为空") String orderNo);




}
