package com.clx.performance.service.loan;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.PageCarrierOwnerRepaymentParam;
import com.clx.performance.param.pc.loan.carrier.PageOwnerRepaymentOfOwner;
import com.clx.performance.param.pc.loan.owner.ExportPaymentApplicationFormParam;
import com.clx.performance.vo.pc.loan.carrier.OwnerRepaymentVO;
import com.clx.performance.vo.pc.loan.owner.OwnerCashierInfoVO;
import com.clx.performance.vo.pc.loan.owner.OwnerOrderPaymentDetailVO;
import com.clx.performance.vo.pc.loan.owner.OwnerTransferPaymentDetailVO;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
public interface OwnerRepaymentService {

    IPage<OwnerRepaymentVO> pageOwnerRepayment(PageCarrierOwnerRepaymentParam param);

    IPage<OwnerRepaymentVO> ownerRepaymentOverdueList();

    IPage<OwnerRepaymentVO> pageOwnerRepaymentOfOwner(PageOwnerRepaymentOfOwner param);

    OwnerCashierInfoVO getCashierInfo(Integer id);

    OwnerOrderPaymentDetailVO getOrderPaymentDetail(Integer id);

    OwnerTransferPaymentDetailVO getTransferPaymentDetail(Integer id);

    String savePaymentApplicationForm(ExportPaymentApplicationFormParam param);

    String sendPaymentSms(String mobile,Long repaymentNo);
    String sendOrderPaySms(String mobile,String payee, String payeeAccount);

    void ownerRepaymentCancelPay(String repaymentNo);

    void ownerRepaymentRetryPay(String repaymentNo);

    void paySuccess(String merSeqNo);

    void payFail(String merSeqNo);
}
