package com.clx.performance.service.impl.loan;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.loan.OwnerPaymentDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.loan.OwnerPayment;
import com.clx.performance.param.pc.loan.carrier.PageCarrierOwnerPaymentParam;
import com.clx.performance.service.loan.OwnerPaymentService;
import com.clx.performance.struct.loan.OwnerPaymentStruct;
import com.clx.performance.vo.pc.loan.carrier.CarrierOwnerPaymentVO;
import com.clx.performance.vo.pc.loan.carrier.OwnerPaymentVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Service
@Slf4j
@AllArgsConstructor
public class OwnerPaymentServiceImpl  implements OwnerPaymentService {
    private final OwnerPaymentDao ownerPaymentDao;
    private final OwnerPaymentStruct ownerPaymentStruct;
    @Override
    public IPage<OwnerPaymentVO> pageOwnerPayment(PageCarrierOwnerPaymentParam param) {
        IPage<OwnerPayment> page = ownerPaymentDao.pageOwnerPayment(param);
        List<OwnerPaymentVO> records = ownerPaymentStruct.convertList(page.getRecords());
        IPage<OwnerPaymentVO> returnPage = new Page<>();
        returnPage.setPages(page.getPages());
        returnPage.setTotal(page.getTotal());
        returnPage.setRecords(records);
        return returnPage;
    }

    @Override
    public CarrierOwnerPaymentVO getOwnerPaymentDetail(Integer id) {
        OwnerPayment ownerPayment = ownerPaymentDao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        return ownerPaymentStruct.convert(ownerPayment);
    }
}
