package com.clx.performance.dao.impl.integral;

import com.clx.performance.dao.integral.IntegralRuleDao;
import com.clx.performance.mapper.integral.IntegralRuleMapper;
import com.clx.performance.model.integral.IntegralRule;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

/**
 * @Author: aiqinguo
 * @Description: 积分规则
 * @Date: 2023-10-9 12:00:54
 * @Version: 1.0
 */
@Repository
public class IntegralRuleDaoImpl extends BaseDaoImpl<IntegralRuleMapper, IntegralRule, Integer> implements IntegralRuleDao {

    @Override
    public boolean update(IntegralRule item) {
        return update(lUdWrapper()
                .eq(IntegralRule::getId, item.getId())
                .set(IntegralRule::getOrderChildCompleteRuleJson, item.getOrderChildCompleteRuleJson())
                .set(IntegralRule::getOrderAwardRuleJson, item.getOrderAwardRuleJson())
                .set(IntegralRule::getOrderDiscountRuleJson, item.getOrderDiscountRuleJson())
                .set(IntegralRule::getOrderChildTimeoutRuleJson, item.getOrderChildTimeoutRuleJson())
                .set(IntegralRule::getPlatformCompensationRuleJson, item.getPlatformCompensationRuleJson())
                .set(IntegralRule::getDriverReportRuleJson, item.getDriverReportRuleJson())
        );
    }

}
