package com.clx.performance.controller.pc.loan.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.PageCarrierOwnerPaymentParam;
import com.clx.performance.service.loan.OwnerPaymentService;
import com.clx.performance.vo.pc.loan.carrier.CarrierOwnerPaymentVO;
import com.clx.performance.vo.pc.loan.carrier.OwnerPaymentVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/ownerPayment")
@Validated
@Api(tags = "承运端-借款管理")
@AllArgsConstructor
public class CarrierOwnerPaymentController {

    private final OwnerPaymentService ownerPaymentService;


    @ApiOperation(value = "付款列表",notes = "<br>By:刘海泉")
    @PostMapping("/pageOwnerPayment")
    @UnitCovert(param = false)
    public Result<PageData<OwnerPaymentVO>> pageOwnerPayment(@RequestBody @Validated PageCarrierOwnerPaymentParam param) {
        IPage<OwnerPaymentVO> page  = ownerPaymentService.pageOwnerPayment(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }



    @ApiOperation(value = "付款详情",notes = "<br>By:刘海泉")
    @PostMapping("/getOwnerPaymentDetail")
    @UnitCovert(param = false)
    public Result<CarrierOwnerPaymentVO> getOwnerPaymentDetail(@RequestParam("id") @NotNull(message = "id不能为空") Integer id) {
        CarrierOwnerPaymentVO vo = ownerPaymentService.getOwnerPaymentDetail(id);
        return Result.ok(vo);
    }





}
