package com.clx.performance.controller.payment;

import com.clx.performance.param.pay.NotifyString;
import com.clx.performance.service.breakcontract.BreakContractMqHandlerService;
import com.clx.performance.service.settle.SettlementMqHandlerService;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import java.util.Objects;


@Slf4j
@RestController
@RequestMapping(value="/payment/notify")
@Validated
@Api(tags = "承运端-支付回调")
@AllArgsConstructor
public class PayNotifyController {
    @Autowired
    private SettlementMqHandlerService settlementMqHandlerService;

    @Autowired
    private BreakContractMqHandlerService breakContractMqHandlerService;

    @ApiOperation(value = "用户支付完成回调接口", notes = " <br>By:胡宁宁")
    @RequestMapping(value = "/userPayNotify", method = RequestMethod.POST)
    public Result<Object> userPayNotify(@RequestBody NotifyString notify) {
        log.info("用户支付完成回调接口 传参 {}", notify);
        if (Objects.isNull(notify) || Objects.isNull(notify.getCode()) || Objects.isNull(notify.getAction())) {
            return new Result<>();
        }
        if (notify.getCode() != 0) {
            // 支付失败处理
            log.info("支付失败处理 唯一id {}", notify.getOrderNo());
            settlementMqHandlerService.settlementDriverNotify(notify.getOrderNo(),0,notify.getMsg());
        } else {
            // 支付支付成功处理
            log.info(" 支付支付成功处理 唯一id {}", notify.getOrderNo());
            settlementMqHandlerService.settlementDriverNotify(notify.getOrderNo(),1,notify.getMsg());
        }
        Result<Object> ret = new Result<>();
        return ret;
    }


    @ApiOperation(value = "用户支付完成回调接口", notes = " <br>By:胡宁宁")
    @RequestMapping(value = "/userPayBrokerContractNotify", method = RequestMethod.POST)
    public Result<Object> userPayBrokerContractNotify(@RequestBody NotifyString notify) {
        log.info("用户支付完成回调接口 传参 {}", notify);
        if (Objects.isNull(notify) || Objects.isNull(notify.getCode()) || Objects.isNull(notify.getAction())) {
            return new Result<>();
        }
        if (notify.getCode() != 0) {
            breakContractMqHandlerService.payFail(notify.getOrderNo(), notify.getMsg());

            // 支付失败处理
            log.info("支付失败处理 唯一id {}", notify.getOrderNo());
        } else {

            breakContractMqHandlerService.paySuccess(notify.getOrderNo());

            // 支付支付成功处理
            log.info(" 支付支付成功处理 唯一id {}", notify.getOrderNo());
        }
        Result<Object> ret = new Result<>();
        return ret;
    }
}
