package com.clx.performance.vo.app;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.math.RoundingMode;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildFreightInfoVO {

    @ApiModelProperty(value = "货物id", example = "1")
    private Integer goodsId;
    @ApiModelProperty(value = "货物名称", example = "煤")
    private String goodsName;
    @ApiModelProperty(value = "运费单价（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freightPrice;

    @ApiModelProperty(value = "装货毛重（单位吨）", example = "1.23")
    private BigDecimal loadRough;
    @ApiModelProperty(value = "装货皮重（单位吨）", example = "1.23")
    private BigDecimal loadTare;
    @ApiModelProperty(value = "装货净重（单位吨）", example = "1.23")
    private BigDecimal loadNet;
    @ApiModelProperty(value = "卸货毛重（单位吨）", example = "1.23")
    private BigDecimal unloadRough;
    @ApiModelProperty(value = "卸货皮重（单位吨）", example = "1.23")
    private BigDecimal unloadTare;
    @ApiModelProperty(value = "卸货净重（单位吨）", example = "1.23")
    private BigDecimal unloadNet;

    @ApiModelProperty(value = "拉运重量（单位吨）", example = "1.23")
    private BigDecimal weight;
    @ApiModelProperty(value = "运费（元）（实际运费）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freight;

    @ApiModelProperty(value = "总运费（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal totalFreight;
    public BigDecimal getTotalFreight() {
        return freightPrice.multiply(weight).setScale(0, RoundingMode.HALF_UP);
    }

    @ApiModelProperty(value = "亏吨扣款（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossFreight;
    public BigDecimal getLossFreight() {
        return (loadNet==null || unloadNet==null || unloadNet.compareTo(loadNet)>0)? BigDecimal.ZERO : freightPrice.multiply(loadNet.subtract(unloadNet)).setScale(0, RoundingMode.HALF_UP);
    }

    @ApiModelProperty(value = "状态", example = "0")
    private Integer status;

}