package com.clx.performance.service.impl;

import com.clx.performance.model.IntegralTruck;
import com.clx.performance.service.IntegralJobHandlerService;
import com.clx.performance.service.IntegralMqService;
import com.clx.performance.utils.LocalDateTimeUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class IntegralJobHandlerServiceImpl implements IntegralJobHandlerService {


    @Autowired
    private IntegralMqService integralMqService;


    /**
     * 下周车辆初始化
     */
    @Override
    public void nextWeekTruckInit(){

        // 发送mq (下周车辆初始化)
        integralMqService.nextWeekTruckInit(LocalDateTimeUtils.getWeekStart());

    }

    /**
     * 车辆周统计 (结算上周积分)
     */
    @Override
    public void weekTruckStatistics(){

        // 发送mq (下周车辆初始化)
        integralMqService.weekTruckStatistics(LocalDateTimeUtils.getWeekStart());
    }
    @Override
    public void weekTruckStatistics(IntegralTruck truck){

        // 发送mq (下周车辆初始化)
        integralMqService.weekTruckStatistics(LocalDateTimeUtils.getWeekStart(), truck.getTruckNo());
    }

    /**
     * 车辆保护取消
     */
    @Override
    public void truckProtectionCancel(IntegralTruck truck){

        // 发送mq (车辆保护取消)
        integralMqService.truckProtectionCancel(LocalDateTimeUtils.getWeekStart(), truck.getTruckNo());
    }

}
