package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.IntegralStatisticsDao;
import com.clx.performance.mapper.IntegralStatisticsMapper;
import com.clx.performance.model.IntegralStatistics;
import com.clx.performance.param.pc.PageIntegralStatisticsParam;
import com.clx.performance.vo.pc.IntegralStatisticsVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 积分排名统计
 * @Date: 2023-10-9 12:00:54
 * @Version: 1.0
 */
@Repository
public class IntegralStatisticsDaoImpl extends BaseDaoImpl<IntegralStatisticsMapper, IntegralStatistics, Integer> implements IntegralStatisticsDao {


    @Override
    public boolean updateIntegral(IntegralStatistics item) {
        return update(lUdWrapper()
                .eq(IntegralStatistics::getId, item.getId())
                .set(IntegralStatistics::getIntegral, item.getIntegral())
        );
    }

    @Override
    public boolean batchUpdateRank(List<IntegralStatistics> list) {
        return baseMapper.batchUpdateRank(list)>0;
    }

    @Override
    public Optional<IntegralStatistics> selectByTruckNoAndStatisticsDate(String truckNo, String statisticsDate) {
        return Optional.of(truckNo)
                .map(item -> lQrWrapper()
                        .eq(IntegralStatistics::getTruckNo, item)
                        .eq(IntegralStatistics::getStatisticsDate, statisticsDate)
                )
                .map(super::getOne);
    }

    @Override
    public IPage<IntegralStatisticsVO> pageByParam(PageIntegralStatisticsParam param) {
        return baseMapper.pageByParam(Page.of(param.getPage(), param.getPageSize()), param);

    }

    @Override
    public Optional<IntegralStatistics> selectById(Integer id) {
        return Optional.of(id)
                .map(item -> lQrWrapper()
                        .eq(IntegralStatistics::getId, item)
                )
                .map(super::getOne);
    }

    @Override
    public List<IntegralStatistics> selectByStatisticsDate(String statisticsDate) {
        return list(lQrWrapper()
                .eq(IntegralStatistics::getStatisticsDate, statisticsDate)
                .orderByDesc(IntegralStatistics::getIntegral));
    }

    @Override
    public List<IntegralStatistics> selectListByStatisticsDateAndTruckNoList(String statisticsDate, List<String> truckNoList) {
        return list(lQrWrapper()
                .eq(IntegralStatistics::getStatisticsDate, statisticsDate)
                .in(IntegralStatistics::getTruckNo, truckNoList));
    }

    @Override
    public int countByStatisticsDate(String statisticsDate) {
        return (int)count(lQrWrapper()
                .eq(IntegralStatistics::getStatisticsDate, statisticsDate)
        );
    }

}
