package com.clx.performance.job.settlement;

import com.clx.performance.dao.settle.SettlementOwnerDao;
import com.clx.performance.enums.settle.SettlementOwnerEnum;
import com.clx.performance.service.settle.SettlementOwnerService;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.msl.common.job.JobLog;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

@Slf4j
@Component
public class SettlementOwnerMontnJob {

    @Autowired
    SettlementOwnerService settlementOwnerService;
    @Autowired
    private SettlementOwnerDao settlementOwnerDao;

    /**
     * 月结货主结算单状态变更为锁定
     */
    @XxlJob("settlementOwnerMontnInit")
    public void settlementOwnerMontnInit() {
        try {
            //所有月结的待锁定的货主结算单修改状态为锁定
            settlementOwnerService.updateStatusByOrderNo(null,
                    SettlementOwnerEnum.SettlementPeriodType.MONTH.getCode(),
                    SettlementOwnerEnum.Status.TO_BE_LOCKED.getCode(),
                    SettlementOwnerEnum.Status.TO_BE_ACCOUNT.getCode());
        } catch (Exception e) {
            log.warn("月结货主结算单状态变更为锁定，异常原因:{}",e);
            JobLog.error("月结货主结算单状态变更为锁定，异常原因=====================", e);
        }
    }

    /**
     * 日结货主结算单状态变更为锁定
     */
    @XxlJob("settlementOwnerDailyInit")
    public void settlementOwnerDailyInit() {
        try {
            // 锁定前一天数据
            LocalDateTime settlementPeriodTime = LocalDateTimeUtils.getDayStart().minusDays(1);

            //所有日结的待锁定的货主结算单修改状态为锁定
            settlementOwnerDao.updateDailyLock(
                    SettlementOwnerEnum.SettlementPeriodType.DAILY.getCode(),
                    settlementPeriodTime,
                    SettlementOwnerEnum.Status.TO_BE_LOCKED.getCode(),
                    SettlementOwnerEnum.Status.TO_BE_ACCOUNT.getCode());
        } catch (Exception e) {
            log.warn("日结货主结算单状态变更为锁定，异常原因:{}",e);
            JobLog.error("日结货主结算单状态变更为锁定，异常原因=====================", e);
        }
    }

}
