package com.clx.performance.vo.pc.vehiclewarn;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 预警日志
* @Date: 2024/04/26 11:21:25
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
public class VehicleWarnLogVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "预警信息id", example = "1")
    private Integer infoId;
    @ApiModelProperty(value = "类型：1暂停预警 2处理预警", example = "1")
    private Integer type;
    @ApiModelProperty(value = "运单编号", example = "100000")
    private String childNo;
    @ApiModelProperty(value = "预警名称", example = "超时")
    private String warnName;
    @ApiModelProperty(value = "预警时间", example = "")
    private String warnTime;
    @ApiModelProperty(value = "预警屏蔽范围：1运单 2货单 3无预警", example = "1")
    private Integer warnRang;
    @ApiModelProperty(value = "预警屏蔽结束时间", example = "")
    private LocalDateTime warnEndTime;
    @ApiModelProperty(value = "内容", example = "预警处理")
    private String content;
    @ApiModelProperty(value = "创建人", example = "")
    private String createBy;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;
    @ApiModelProperty(value = "修改时间", example = "")
    private String modifiedTime;

}