package com.clx.performance.enums.loan;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum OwnerPaymentEnum {
    ;

    //“待付款”，“付款中”，“付款成功”，“付款失败”
    @Getter
    @AllArgsConstructor
    public enum Status {
        PAY_WAIT(10, "待付款"),
        PAYING(40, "付款中"),
        PAY_SUCCESS(50, "付款成功"),
        PAY_FAIL(60, "付款失败"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<OwnerPaymentEnum.Status> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.code , code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(OwnerPaymentEnum.Status::getMsg).orElse(null);
        }
    }

}
