package com.clx.performance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.component.IdGenerateSnowFlake;
import com.clx.performance.dao.*;
import com.clx.performance.enums.IdTypeEnum;
import com.clx.performance.enums.OwnerAccountEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.*;
import com.clx.performance.param.open.OpenOwnerBindCardParam;
import com.clx.performance.param.open.OpenOwnerCaseOutParam;
import com.clx.performance.param.open.OpenOwnerTopUpParam;
import com.clx.performance.param.pc.*;
import com.clx.performance.param.pc.owner.CreteAccountParam;
import com.clx.performance.param.pc.owner.FrozenAccountParam;
import com.clx.performance.service.OwnerAccountService;
import com.clx.performance.struct.OwnerAccountStruct;
import com.clx.performance.utils.excel.ExcelData;
import com.clx.performance.utils.excel.ExcelField;
import com.clx.performance.utils.excel.ExcelSheet;
import com.clx.performance.utils.excel.ExcelUtil;
import com.clx.performance.vo.pc.OwnerAccountRunningWaterRecordVO;
import com.clx.performance.vo.pc.OwnerAccountVO;
import com.clx.user.enums.driver.DriverTruckEnum;
import com.clx.user.feign.OwnerInfoFeign;
import com.clx.user.param.pc.owner.UpdateOwnerBindCardFeignParam;
import com.clx.user.vo.pc.driver.truck.DriverTruckVo;
import com.clx.user.vo.pc.owner.OwnerBindCardVO;
import com.msl.common.base.Optional;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;

@Slf4j
@Service
@AllArgsConstructor
public class OwnerAccountServiceImpl implements OwnerAccountService {

    private final OwnerAccountDao ownerAccountDao;

    private final OwnerRunningWaterRecordDao ownerRunningWaterRecordDao;

    private final IdGenerateSnowFlake idGenerateSnowFlake;

    private final OwnerTopUpDao ownerTopUpDao;

    private final OwnerCaseOutDao ownerCaseOutDao;

    private final OwnerTransferInfoDao ownerTransferInfoDao;

    private final OwnerInfoFeign ownerInfoFeign;

    private final OwnerBindCardRecordDao ownerBindCardRecordDao;

    private final OwnerAccountStruct ownerAccountStruct;

    @Override
    public IPage<OwnerAccountVO> pageList(PageOwnerAccountListParam param) {
        return ownerAccountDao.pageList(param);
    }

    @Override
    public IPage<OwnerAccountRunningWaterRecordVO> marginAccountPageList(PagePlatformMarginAccountParam param) {
        return ownerRunningWaterRecordDao.marginAccountPageList(param);
    }

    @Override
    public IPage<OwnerAccountRunningWaterRecordVO> prepaidFreightAccountPageList(PagePlatformPrepaidFreightAccountParam param) {
        return ownerRunningWaterRecordDao.prepaidFreightAccountPageList(param);
    }

    @Override
    public Map<String,OwnerAccountVO> accountInfo(Long ownerUserNo) {
        Map<String,OwnerAccountVO> result = new HashMap<>(2);
        List<OwnerAccountVO> list = ownerAccountStruct.convertList(ownerAccountDao.accountInfo(ownerUserNo));
        for (OwnerAccountVO ownerAccountVO : list) {
            if (OwnerAccountEnum.AccountTypeStatus.MARGIN_ACCOUNT.getCode().equals(ownerAccountVO.getAccountType())) {
                result.put("marginAccount", ownerAccountVO);
            } else {
                result.put("prepaidFreightAccount", ownerAccountVO);
            }
        }
        return result;
    }

    @Override
    public Long accountTopUp(OwnerTopUpParam param) {
        OwnerTopUp entity = new OwnerTopUp();
        entity.setAccountType(param.getAccountType());
        entity.setOwnerUserNo(param.getOwnerUserNo());
        entity.setTopUpBalance(param.getTopUpBalance());
        entity.setStatus(OwnerAccountEnum.TopUpStatus.PENDING.getCode());
        entity.setDrawingBank(param.getDrawingBank());
        entity.setDrawingBankNumber(param.getDrawingBankNumber());
        entity.setDrawingProof(param.getDrawingProof());
        //充值编号
        entity.setTopUpNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.TOP_UP.getCode()));

        ownerTopUpDao.saveEntity(entity);
        return entity.getTopUpNo();
    }

    public Long openAccountTopUp(OpenOwnerTopUpParam param) {
        OwnerTopUp entity = new OwnerTopUp();
        entity.setAccountType(param.getAccountType());
        entity.setOwnerUserNo(param.getOwnerUserNo());
        entity.setTopUpBalance(param.getTopUpBalance());
        entity.setStatus(OwnerAccountEnum.TopUpStatus.PENDING.getCode());
        entity.setDrawingBank(param.getDrawingBank());
        entity.setDrawingBankNumber(param.getDrawingBankNumber());
        entity.setDrawingProof(param.getDrawingProof());
        //充值编号
        entity.setTopUpNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.TOP_UP.getCode()));

        ownerTopUpDao.saveEntity(entity);
        return entity.getTopUpNo();
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long accountCaseOut(OwnerCaseOutParam param) {
        BigDecimal caseOutBalance = param.getCaseOutBalance();
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        param.setOwnerUserNo(loginUserInfo.getUserNo());

        LocalDateTime now = LocalDateTime.now();
        while (true) {
            //冻结账户可用金额
            OwnerAccount account = ownerAccountDao.getAccountByOwnerUserNoAndAccountType(param.getOwnerUserNo(), param.getAccountType());
            if (account.getUsableBalance().compareTo(caseOutBalance) < 0) {
                throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前用户可用余额不足,无法提现");
            }
            OwnerAccount update = new OwnerAccount();
            update.setUsableBalance(caseOutBalance);
            update.setFrozenBalance(caseOutBalance);
            update.setAccountBalance(caseOutBalance);
            update.setModifiedTime(account.getModifiedTime());
            update.setId(account.getId());
            Integer flag = ownerAccountDao.updateAccountCAS(update, now, false);
            if (null != flag) {
                break;
            }
        }

        //提现记录
        OwnerCaseOut entity = new OwnerCaseOut();
        entity.setAccountType(param.getAccountType());
        entity.setCaseOutNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.CASE_OUT.getCode()));
        entity.setCaseOutBalance(caseOutBalance);
        entity.setOwnerUserNo(param.getOwnerUserNo());
        entity.setStatus(OwnerAccountEnum.CaseOutStatus.PENDING_PAYMENT.getCode());
        entity.setCaseOutBank(param.getOwnerOpenBank());
        entity.setCaseOutBankNumber(param.getOwnerBankAccount());

        ownerCaseOutDao.saveEntity(entity);
        //插入冻结流水
        OwnerRunningWaterRecord runningWaterRecord = new OwnerRunningWaterRecord();
        runningWaterRecord.setOwnerName(loginUserInfo.getUserName());
        runningWaterRecord.setMobile(loginUserInfo.getUserMobile());
        runningWaterRecord.setCreateBy(loginUserInfo.getUserName());
        runningWaterRecord.setRelationId(entity.getCaseOutNo());
        runningWaterRecord.setAccountBalance(caseOutBalance);
        runningWaterRecord.setOwnerUserNo(param.getOwnerUserNo());
        runningWaterRecord.setAccountType(param.getAccountType());
        runningWaterRecord.setRunningWaterType(OwnerAccountEnum.RunningWaterStatus.FROZEN.getCode());
        runningWaterRecord.setRunningWaterNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.CASE_OUT_FROZEN.getCode()));
        ownerRunningWaterRecordDao.saveEntity(runningWaterRecord);

        return entity.getCaseOutNo();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long openAccountCaseOut(OpenOwnerCaseOutParam param) {
        BigDecimal caseOutBalance = param.getCaseOutBalance();
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        param.setOwnerUserNo(loginUserInfo.getUserNo());
        LocalDateTime now = LocalDateTime.now();
        while (true) {
            //冻结账户可用金额
            OwnerAccount account = ownerAccountDao.getAccountByOwnerUserNoAndAccountType(param.getOwnerUserNo(), param.getAccountType());
            OwnerAccount update = new OwnerAccount();
            update.setUsableBalance(caseOutBalance.negate());
            update.setFrozenBalance(caseOutBalance);
            update.setModifiedTime(account.getModifiedTime());
            update.setId(account.getId());
            Integer flag = ownerAccountDao.updateAccountCAS(update, now, false);
            if (null != flag) {
                break;
            }
        }

        //提现记录
        OwnerCaseOut entity = new OwnerCaseOut();
        entity.setAccountType(param.getAccountType());
        entity.setCaseOutNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.CASE_OUT.getCode()));
        entity.setOwnerUserNo(param.getOwnerUserNo());
        entity.setStatus(OwnerAccountEnum.CaseOutStatus.PENDING_PAYMENT.getCode());
        entity.setCaseOutBank(param.getCaseOutBank());
        entity.setCaseOutBankNumber(param.getCaseOutBankNumber());

        ownerCaseOutDao.saveEntity(entity);
        //插入冻结流水
        OwnerRunningWaterRecord runningWaterRecord = new OwnerRunningWaterRecord();
        runningWaterRecord.setOwnerName(loginUserInfo.getUserName());
        runningWaterRecord.setMobile(loginUserInfo.getUserMobile());
        runningWaterRecord.setCreateBy(loginUserInfo.getUserName());
        runningWaterRecord.setRelationId(entity.getCaseOutNo());
        runningWaterRecord.setAccountBalance(caseOutBalance);
        runningWaterRecord.setOwnerUserNo(param.getOwnerUserNo());
        runningWaterRecord.setAccountType(param.getAccountType());
        runningWaterRecord.setRunningWaterType(OwnerAccountEnum.RunningWaterStatus.FROZEN.getCode());
        runningWaterRecord.setRunningWaterNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.CASE_OUT_FROZEN.getCode()));
        ownerRunningWaterRecordDao.saveEntity(runningWaterRecord);

        return entity.getCaseOutNo();
    }

    /**
     * 充值审批
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void accountTopUpApprove(PlatformAccountTopUpParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Optional<OwnerTopUp> optional = ownerTopUpDao.getEntityByKey(param.getId());
        if (!optional.isPresent()) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前ID未查询到有效记录");
        }
        OwnerTopUp ownerTopUp = optional.get();
        OwnerTopUp entity = new OwnerTopUp();
        String ownerName = "";
        if (!param.getPassType()) {
            entity.setId(param.getId());
            entity.setApprovalTurnDown(param.getTurnDownContent());
            entity.setStatus(OwnerAccountEnum.TopUpStatus.APPROVAL_REJECTION.getCode());
            ownerTopUpDao.updateEntityByKey(entity);
        } else {
            //给对应账户增加金额
            BigDecimal topUpBalance = ownerTopUp.getTopUpBalance();
            LocalDateTime now = LocalDateTime.now();
            while (true) {
                OwnerAccount account = ownerAccountDao.getAccountByOwnerUserNoAndAccountType(param.getOwnerUserNo(), param.getAccountType());
                OwnerAccount update = new OwnerAccount();
                update.setAccountBalance(topUpBalance);
                update.setUsableBalance(topUpBalance);
                update.setId(account.getId());
                update.setModifiedTime(account.getModifiedTime());
                Integer flag = ownerAccountDao.updateAccountCAS(update, now, true);
                if (null != flag) {
                    ownerName = account.getOwnerUserName();
                    break;
                }
            }

            entity.setId(param.getId());
            entity.setStatus(OwnerAccountEnum.TopUpStatus.APPROVAL_APPROVE.getCode());
            ownerTopUpDao.updateEntityByKey(entity);
            //需要插入充值流水
            OwnerRunningWaterRecord runningWaterRecord = new OwnerRunningWaterRecord();
            runningWaterRecord.setOwnerName(ownerName);
            runningWaterRecord.setMobile(loginUserInfo.getUserMobile());
            runningWaterRecord.setCreateBy(loginUserInfo.getUserName());

            runningWaterRecord.setRelationId(ownerTopUp.getTopUpNo());
            runningWaterRecord.setAccountBalance(topUpBalance);
            runningWaterRecord.setOwnerUserNo(param.getOwnerUserNo());

            runningWaterRecord.setAccountType(param.getAccountType());
            runningWaterRecord.setRunningWaterType(OwnerAccountEnum.RunningWaterStatus.TOP_UP.getCode());
            runningWaterRecord.setRunningWaterNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.TOP_UP_SUCCESS.getCode()));
            ownerRunningWaterRecordDao.saveEntity(runningWaterRecord);

        }
    }

    /**
     * 提现审批
     *
     * @param param
     */
    @Override
    public void accountCaseOutApprove(OwnerCaseOutApproveParam param) {
        OwnerCaseOut entity = new OwnerCaseOut();
        entity.setId(param.getId());
        entity.setPaymentProof(param.getPaymentProof());
        entity.setPlatformPaymentBank(entity.getPlatformPaymentBank());
        entity.setPlatformPaymentBankNumber(param.getPlatformPaymentBankNumber());
        entity.setPlatformPayBalance(param.getPlatformPayBalance());
        entity.setStatus(OwnerAccountEnum.CaseOutStatus.TO_BE_CONFIRMED.getCode());
        ownerCaseOutDao.updateEntityByKey(entity);
    }

    @Override
    public void accountBalanceConfirm(Integer id) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();

        Optional<OwnerCaseOut> optional = ownerCaseOutDao.getEntityByKey(id);
        if (!optional.isPresent()) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前ID未查询到有效记录");
        }
        OwnerCaseOut ownerCaseOut = optional.get();
        BigDecimal caseOutBalance = ownerCaseOut.getCaseOutBalance();
        BigDecimal platformPayBalance = ownerCaseOut.getPlatformPayBalance();
        if (platformPayBalance.compareTo(caseOutBalance) != 0) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "货主提现金额和平台支付金额不一致");
        }

        //给对应账户减少金额
        while (true) {
            OwnerAccount account = ownerAccountDao.getAccountByOwnerUserNoAndAccountType(ownerCaseOut.getOwnerUserNo(), ownerCaseOut.getAccountType());
            OwnerAccount update = new OwnerAccount();
            update.setFrozenBalance(caseOutBalance);
            update.setId(account.getId());
            update.setModifiedTime(account.getModifiedTime());
            Integer flag = ownerAccountDao.updateOwnerAccountForConfirm(update);
            if (flag > 0) {
                break;
            }
        }


        //插入提现成功流水
        OwnerRunningWaterRecord runningWaterRecord = new OwnerRunningWaterRecord();
        runningWaterRecord.setOwnerName(loginUserInfo.getUserName());
        runningWaterRecord.setMobile(loginUserInfo.getUserMobile());
        runningWaterRecord.setCreateBy(loginUserInfo.getUserName());

        runningWaterRecord.setRelationId(ownerCaseOut.getCaseOutNo());
        runningWaterRecord.setAccountBalance(caseOutBalance);
        runningWaterRecord.setOwnerUserNo(ownerCaseOut.getOwnerUserNo());

        runningWaterRecord.setAccountType(ownerCaseOut.getAccountType());
        runningWaterRecord.setRunningWaterType(OwnerAccountEnum.RunningWaterStatus.CASE_OUT_SUCCESS.getCode());
        runningWaterRecord.setRunningWaterNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.CASE_OUT_SUCCESS.getCode()));
        ownerRunningWaterRecordDao.saveEntity(runningWaterRecord);

    }

    @Override
    public SXSSFWorkbook exportMarginAccountPageList(PagePlatformMarginAccountParam param) {
        IPage<OwnerAccountRunningWaterRecordVO> page = ownerRunningWaterRecordDao.marginAccountPageList(param);
        List<OwnerAccountRunningWaterRecordVO> list = page.getRecords();
        // 组装表头
        List<ExcelField> fieldList = new ArrayList<>();
        fieldList.add(new ExcelField(0, "序号", "index", 2000));
        fieldList.add(new ExcelField(1, "货主编码", "ownerUserNo", 5000));
        fieldList.add(new ExcelField(2, "货主名称", "ownerName", 5000));
        fieldList.add(new ExcelField(3, "联系电话", "mobile", 5000));
        fieldList.add(new ExcelField(4, "账户类型", "accountType", 15000));
        fieldList.add(new ExcelField(5, "流水类型", "runningWaterType", 5000));
        fieldList.add(new ExcelField(6, "订单编号", "orderNo", 5000));
        fieldList.add(new ExcelField(7, "变动金额", "alterationBalance", 5000));
        fieldList.add(new ExcelField(8, "冻结金额", "frozenBalance", 5000));
        fieldList.add(new ExcelField(9, "可用余额", "usableBalance", 5000));
        fieldList.add(new ExcelField(10, "账户余额", "accountBalance", 5000));
        fieldList.add(new ExcelField(11, "扣除金额", "takeOutBalance", 5000));
        fieldList.add(new ExcelField(12, "流水编号", "runningWaterNo", 5000));
        fieldList.add(new ExcelField(13, "操作人", "createBy", 5000));
        fieldList.add(new ExcelField(14, "操作时间", "createTime", 5000));


        // 组装数据
        List<List<ExcelData>> dataList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {

            OwnerAccountRunningWaterRecordVO dto = list.get(i);
            List<ExcelData> rowData = new ArrayList<>();

            rowData.add(new ExcelData(i + 1));
            rowData.add(new ExcelData(dto.getOwnerUserNo().toString()));
            rowData.add(new ExcelData(dto.getOwnerName()));
            rowData.add(new ExcelData(dto.getMobile()));
            rowData.add(new ExcelData(OwnerAccountEnum.AccountTypeStatus.getByCode(dto.getAccountType()).get().getMsg()));
            rowData.add(new ExcelData(OwnerAccountEnum.RunningWaterStatus.getByCode(dto.getRunningWaterType()).get().getMsg()));
            rowData.add(new ExcelData(dto.getOrderNo()));
            rowData.add(new ExcelData(dto.getAlterationBalance()));
            rowData.add(new ExcelData(dto.getFrozenBalance()));
            rowData.add(new ExcelData(dto.getUsableBalance()));
            rowData.add(new ExcelData(dto.getAccountBalance()));
            rowData.add(new ExcelData(dto.getTakeOutBalance()));
            rowData.add(new ExcelData(dto.getRunningWaterNo().toString()));
            rowData.add(new ExcelData(dto.getCreateBy()));
            rowData.add(new ExcelData(dto.getCreateTime().toString()));

            dataList.add(rowData);
        }

        ExcelSheet excelSheet = new ExcelSheet("保证金账户详情", "保证金账户详情", fieldList, dataList);

        //创建excel
        return ExcelUtil.create(excelSheet);
    }

    @Override
    public SXSSFWorkbook exportPrepaidFreightAccountPageList(PagePlatformPrepaidFreightAccountParam param) {
        IPage<OwnerAccountRunningWaterRecordVO> page = ownerRunningWaterRecordDao.prepaidFreightAccountPageList(param);
        List<OwnerAccountRunningWaterRecordVO> list = page.getRecords();
        // 组装表头
        List<ExcelField> fieldList = new ArrayList<>();
        fieldList.add(new ExcelField(0, "序号", "index", 2000));
        fieldList.add(new ExcelField(1, "货主编码", "ownerUserNo", 5000));
        fieldList.add(new ExcelField(2, "货主名称", "ownerName", 5000));
        fieldList.add(new ExcelField(3, "联系电话", "mobile", 5000));
        fieldList.add(new ExcelField(4, "账户类型", "accountType", 15000));
        fieldList.add(new ExcelField(5, "流水类型", "runningWaterType", 5000));
        fieldList.add(new ExcelField(6, "订单编号", "orderNo", 5000));
        fieldList.add(new ExcelField(7, "运单编号", "orderChildNo", 5000));

        fieldList.add(new ExcelField(8, "变动金额", "alterationBalance", 5000));
        fieldList.add(new ExcelField(9, "冻结金额", "frozenBalance", 5000));
        fieldList.add(new ExcelField(10, "可用余额", "usableBalance", 5000));
        fieldList.add(new ExcelField(11, "账户余额", "accountBalance", 5000));
        fieldList.add(new ExcelField(12, "扣除金额", "takeOutBalance", 5000));
        fieldList.add(new ExcelField(13, "流水编号", "runningWaterNo", 5000));
        fieldList.add(new ExcelField(14, "操作人", "createBy", 5000));
        fieldList.add(new ExcelField(15, "操作时间", "createTime", 5000));


        // 组装数据
        List<List<ExcelData>> dataList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {

            OwnerAccountRunningWaterRecordVO dto = list.get(i);
            List<ExcelData> rowData = new ArrayList<>();

            rowData.add(new ExcelData(i + 1));
            rowData.add(new ExcelData(dto.getOwnerUserNo().toString()));
            rowData.add(new ExcelData(dto.getOwnerName()));
            rowData.add(new ExcelData(dto.getMobile()));
            rowData.add(new ExcelData(OwnerAccountEnum.AccountTypeStatus.getByCode(dto.getAccountType()).get().getMsg()));
            rowData.add(new ExcelData(OwnerAccountEnum.RunningWaterStatus.getByCode(dto.getRunningWaterType()).get().getMsg()));
            rowData.add(new ExcelData(dto.getOrderNo()));
            rowData.add(new ExcelData(dto.getOrderChildNo()));
            rowData.add(new ExcelData(dto.getAlterationBalance()));
            rowData.add(new ExcelData(dto.getFrozenBalance()));
            rowData.add(new ExcelData(dto.getUsableBalance()));
            rowData.add(new ExcelData(dto.getAccountBalance()));
            rowData.add(new ExcelData(dto.getTakeOutBalance()));
            rowData.add(new ExcelData(dto.getRunningWaterNo().toString()));
            rowData.add(new ExcelData(dto.getCreateBy()));
            rowData.add(new ExcelData(dto.getCreateTime().toString()));

            dataList.add(rowData);
        }

        ExcelSheet excelSheet = new ExcelSheet("预付账户详情", "预付账户详情", fieldList, dataList);

        //创建excel
        return ExcelUtil.create(excelSheet);
    }

    @Override
    public OwnerTransferInfo transferPublic() {
        return ownerTransferInfoDao.getEntityByKey(1).orElse(null);
    }

    @Override
    public OwnerBindCardVO getOwnerBindCard(Long userNo) {
        Result<OwnerBindCardVO> result = ownerInfoFeign.getOwnerInfoVO(userNo);
        if (result.succeed()) {
            return result.getData();
        } else {
            return null;
        }
    }

    @Override
    public void bindOwnerBindCard(OwnerBindCardParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();

        Result<OwnerBindCardVO> result = ownerInfoFeign.getOwnerInfoVO(loginUserInfo.getUserNo());
        if (!result.succeed()) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前参数未查询到有效数据");
        }
        if (result.succeed() && ObjectUtil.isNotNull(result.getData()) && StringUtils.isNotBlank(result.getData().getOwnerAccountBank())) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前货主存在绑定银行卡,请先解绑银行卡后再进行绑定操作");
        }

        UpdateOwnerBindCardFeignParam feignParam = new UpdateOwnerBindCardFeignParam();
        feignParam.setUserNo(loginUserInfo.getUserNo());
        feignParam.setOwnerAccountBank(param.getOwnerAccountBank());
        feignParam.setOwnerAccountName(param.getOwnerAccountName());
        feignParam.setOwnerBankAccount(param.getOwnerBankAccount());
        feignParam.setOwnerOpenBank(param.getOwnerOpenBank());

        ownerInfoFeign.bindOwnerBindCard(feignParam);
        OwnerBindCardRecord record = new OwnerBindCardRecord();
        record.setOwnerUserNo(loginUserInfo.getUserNo());
        record.setOwnerUserName(loginUserInfo.getUserName());
        record.setCreateItem("绑定银行卡");
        record.setOwnerBank(param.getOwnerAccountBank());
        record.setOpenAccountBank(param.getOwnerAccountBank());
        record.setAccountBankName(param.getOwnerAccountName());
        record.setBankCardNumber(param.getOwnerBankAccount());
        record.setCreateBy("曹做人");
        ownerBindCardRecordDao.saveEntity(record);
    }

    @Override
    public void openBindOwnerBindCard(OpenOwnerBindCardParam param) {

        Result<OwnerBindCardVO> result = ownerInfoFeign.getOwnerInfoVO(param.getUserNo());
        if (!result.succeed()) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前参数未查询到有效数据");
        }
        if (result.succeed() && ObjectUtil.isNotNull(result.getData()) && StringUtils.isNotBlank(result.getData().getOwnerAccountBank())) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前货主存在绑定银行卡,请先解绑银行卡后再进行绑定操作");
        }

        UpdateOwnerBindCardFeignParam feignParam = new UpdateOwnerBindCardFeignParam();
        feignParam.setUserNo(param.getUserNo());
        feignParam.setOwnerAccountBank(param.getOwnerAccountBank());
        feignParam.setOwnerAccountName(param.getOwnerAccountName());
        feignParam.setOwnerBankAccount(param.getOwnerBankAccount());
        feignParam.setOwnerOpenBank(param.getOwnerOpenBank());

        ownerInfoFeign.bindOwnerBindCard(feignParam);
        OwnerBindCardRecord record = new OwnerBindCardRecord();
        record.setOwnerUserNo(param.getUserNo());
        record.setOwnerUserName(param.getName());
        record.setCreateItem("绑定银行卡");
        record.setOwnerBank(param.getOwnerAccountBank());
        record.setOpenAccountBank(param.getOwnerAccountBank());
        record.setAccountBankName(param.getOwnerAccountName());
        record.setBankCardNumber(param.getOwnerBankAccount());
        record.setCreateBy("曹做人");
        ownerBindCardRecordDao.saveEntity(record);
    }

    @Override
    public void unBindOwnerBindCard(OwnerBindCardParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Result<OwnerBindCardVO> result = ownerInfoFeign.getOwnerInfoVO(loginUserInfo.getUserNo());
        if (!result.succeed()) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前参数未查询到有效数据");
        }
        OwnerBindCardRecord record = new OwnerBindCardRecord();
        //record.setOwnerType(param.getOwnerType());
        record.setOwnerUserNo(loginUserInfo.getUserNo());
        record.setCreateItem("解绑银行卡");
        record.setOwnerBank(param.getOwnerAccountBank());
        record.setOpenAccountBank(param.getOwnerAccountBank());
        record.setAccountBankName(param.getOwnerAccountName());
        record.setCreateBy(loginUserInfo.getUserName());
        ownerBindCardRecordDao.saveEntity(record);
        UpdateOwnerBindCardFeignParam feignParam = new UpdateOwnerBindCardFeignParam();
        feignParam.setUserNo(loginUserInfo.getUserNo());
//        feignParam.setOwnerAccountBank(param.getOwnerAccountBank());
//        feignParam.setOwnerAccountName(param.getOwnerAccountName());
//        feignParam.setOwnerBankAccount(param.getOwnerBankAccount());
//        feignParam.setOwnerOpenBank(param.getOwnerOpenBank());

        ownerInfoFeign.unBindOwnerBindCard(feignParam);
    }

    @Override
    public void openUnBindOwnerBindCard(OpenOwnerBindCardParam param) {
        Result<OwnerBindCardVO> result = ownerInfoFeign.getOwnerInfoVO(param.getUserNo());
        if (!result.succeed()) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前参数未查询到有效数据");
        }
        OwnerBindCardRecord record = new OwnerBindCardRecord();
        //record.setOwnerType(param.getOwnerType());
        record.setOwnerUserNo(param.getUserNo());
        record.setCreateItem("解绑银行卡");
        record.setOwnerBank(param.getOwnerAccountBank());
        record.setOpenAccountBank(param.getOwnerAccountBank());
        record.setAccountBankName(param.getOwnerAccountName());
        record.setCreateBy(param.getName());
        ownerBindCardRecordDao.saveEntity(record);
        UpdateOwnerBindCardFeignParam feignParam = new UpdateOwnerBindCardFeignParam();
        feignParam.setUserNo(param.getUserNo());
//        feignParam.setOwnerAccountBank(param.getOwnerAccountBank());
//        feignParam.setOwnerAccountName(param.getOwnerAccountName());
//        feignParam.setOwnerBankAccount(param.getOwnerBankAccount());
//        feignParam.setOwnerOpenBank(param.getOwnerOpenBank());

        ownerInfoFeign.unBindOwnerBindCard(feignParam);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void ownerAccountFrozen(FrozenAccountParam param) {
        String mobile = "";
        Long userNo = param.getUserNo();
        String ownerName = "";
        BigDecimal frozenBalance = param.getFrozenBalance();
        BigDecimal ensureBalance = param.getEnsureBalance();
        Integer orderId = param.getOrderId();
        String orderNo = param.getOrderNo();
        LocalDateTime now = LocalDateTime.now();

        while (true) {
            Integer flag = 0;
            List<OwnerAccount> accountList = ownerAccountDao.accountInfo(userNo);
            for (OwnerAccount ownerAccount : accountList) {
                OwnerAccount entity = new OwnerAccount();
                mobile = ownerAccount.getMobile();
                ownerName = ownerAccount.getOwnerUserName();
                entity.setAccountType(ownerAccount.getAccountType());
                entity.setId(ownerAccount.getId());
                entity.setModifiedTime(ownerAccount.getModifiedTime());
                if (ownerAccount.getAccountType().equals(OwnerAccountEnum.AccountTypeStatus.MARGIN_ACCOUNT.getCode())) {
                    if (ownerAccount.getUsableBalance().compareTo(frozenBalance) < 0) {
                        throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前货主保证金账户可用余额不够冻结");
                    }
                    //冻结金额
                    entity.setFrozenBalance(frozenBalance);
                    //可用余额
                    entity.setUsableBalance(frozenBalance);
                    //账户余额
                    entity.setAccountBalance(frozenBalance);

                    //updateList.add(entity);
                    flag += ownerAccountDao.updateAccountCAS(entity, now, false);
                } else {
                    if (ownerAccount.getUsableBalance().compareTo(ensureBalance) < 0) {
                        throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前货主预付运费账户可用余额不够冻结");
                    }
                    //冻结金额
                    entity.setFrozenBalance(ensureBalance);
                    //可用余额
                    entity.setUsableBalance(ensureBalance);
                    //账户余额
                    entity.setAccountBalance(frozenBalance);
                    //updateList.add(entity);
                    flag += ownerAccountDao.updateAccountCAS(entity, now, false);
                }
            }
            if (flag == 2) {
                break;
            }
        }

        //插入保证金冻结流水
        OwnerRunningWaterRecord marginAccount = new OwnerRunningWaterRecord();
        marginAccount.setOwnerName(ownerName);
        marginAccount.setMobile(mobile);
        marginAccount.setCreateBy("系统");
        marginAccount.setOrderId(orderId);
        marginAccount.setOrderNo(orderNo);

        marginAccount.setRelationId(null);
        marginAccount.setAccountBalance(ensureBalance);
        marginAccount.setOwnerUserNo(userNo);

        marginAccount.setAccountType(OwnerAccountEnum.AccountTypeStatus.MARGIN_ACCOUNT.getCode());
        marginAccount.setRunningWaterType(OwnerAccountEnum.RunningWaterStatus.FROZEN.getCode());
        marginAccount.setRunningWaterNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.FROZEN.getCode()));
        ownerRunningWaterRecordDao.saveEntity(marginAccount);

        //插入预付运费冻结流水
        OwnerRunningWaterRecord prepaidFreight = new OwnerRunningWaterRecord();
        prepaidFreight.setOwnerName(ownerName);
        prepaidFreight.setMobile(mobile);
        prepaidFreight.setCreateBy("系统");
        prepaidFreight.setOrderId(orderId);
        prepaidFreight.setOrderNo(orderNo);

        prepaidFreight.setRelationId(null);
        prepaidFreight.setAccountBalance(frozenBalance);
        prepaidFreight.setOwnerUserNo(userNo);

        prepaidFreight.setAccountType(OwnerAccountEnum.AccountTypeStatus.PREPAID_FREIGHT_ACCOUNT.getCode());
        prepaidFreight.setRunningWaterType(OwnerAccountEnum.RunningWaterStatus.FROZEN.getCode());
        prepaidFreight.setRunningWaterNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.FROZEN.getCode()));
        ownerRunningWaterRecordDao.saveEntity(prepaidFreight);


    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createAccount(CreteAccountParam param) {
        List<OwnerAccount> accountList = ownerAccountDao.accountInfo(param.getUserNo());
        if (CollectionUtil.isNotEmpty(accountList)) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前货主已创建账户");
        }
        OwnerAccount ownerAccount = new OwnerAccount();
        ownerAccount.setAccountType(OwnerAccountEnum.AccountTypeStatus.PREPAID_FREIGHT_ACCOUNT.getCode());
        ownerAccount.setOwnerUserName(param.getName());
        ownerAccount.setOwnerUserNo(param.getUserNo());
        ownerAccount.setMobile(param.getMobile());
        ownerAccountDao.saveEntity(ownerAccount);
        ownerAccount.setAccountType(OwnerAccountEnum.AccountTypeStatus.MARGIN_ACCOUNT.getCode());
        ownerAccountDao.saveEntity(ownerAccount);
    }
}
