package com.clx.performance.model.settle;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 平台服务费
* @Date: 2024/06/18 15:10:40
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class SettlementPlatformServiceFee implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private String childNo;                         //运单编号
    private Long driverUserNo;                      //司机用户编号
    private String driverName;                      //司机名称
    private String driverMobile;                      //司机手机号
    private Integer sendAddressId;                  //发货地址id
    private String sendAddress;                     //发货地址
    private Integer receiveAddressId;               //收货地址id
    private String receiveAddress;                  //收货地址
    private String truckNo;                         //车牌号
    private BigDecimal settlementFreight;           //结算金额（分）
    private BigDecimal invoiceServiceFee;           //开票服务费（分）
    private BigDecimal invoiceServiceFeeRate;       //开票服务率%
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}
