package com.clx.performance.service.impl.child;

import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.service.child.FeignOrderChildService;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.vo.pc.child.OrderChildLineStatisticsVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;

@Slf4j
@Service
public class FeignOrderChildServiceImpl implements FeignOrderChildService {

    @Autowired
    private OrderChildDao orderChildDao;

    @Override
    public OrderChildLineStatisticsVO getLineStatistics(Integer sendSystemAddressId, Integer receiveSystemAddressId) {
        // 磅差
        String beginTime = LocalDateTimeUtils.getStringDayStart(LocalDateTime.now().minusDays(7));
        BigDecimal linePoundDifferenceRatioAvg = orderChildDao.getLinePoundDifferenceRatioAvg(sendSystemAddressId, receiveSystemAddressId, beginTime);

        // 时长
        beginTime = LocalDateTimeUtils.getStringDayStart(LocalDateTime.now().minusMonths(1));
        Integer timeAvg = orderChildDao.getLineArriveSendAddressToUnloadTimeAvg(sendSystemAddressId, receiveSystemAddressId, beginTime);

        OrderChildLineStatisticsVO vo = new OrderChildLineStatisticsVO();

        vo.setPoundDifferenceRatioAvg(linePoundDifferenceRatioAvg==null? null:linePoundDifferenceRatioAvg.setScale(4, RoundingMode.HALF_UP).movePointRight(2));
        vo.setTimeAvg(timeAvg==null? null : timeAvg/60);

        return vo;
    }

}
