package com.clx.performance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.dao.OrderGoodsTruckBindDao;
import com.clx.performance.enums.OrderGoodsTruckBindEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.OrderGoodsTruckBind;
import com.clx.performance.service.OrderGoodsTruckBindService;
import com.clx.performance.vo.app.OrderGoodsAPPVO;
import com.clx.user.feign.TruckFeign;
import com.clx.user.vo.app.driver.truck.DriverTruckAppVo;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import com.msl.common.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
@Slf4j
public class OrderGoodsTruckBindServiceImpl implements OrderGoodsTruckBindService {


    private final OrderGoodsTruckBindDao orderGoodsTruckBindDao;

    private final OrderGoodsDao orderGoodsDao;

    private final TruckFeign truckFeign;

    private final OrderChildDao orderChildDao;

    @Override
    public List<Integer> getTrucksByOrderGoodsNo(String orderGoodsNo) {
        return orderGoodsTruckBindDao.getTrucksByOrderGoodsNo(orderGoodsNo);
    }

    @Override
    public List<OrderGoodsAPPVO> getCancelOrderGoods(Long userNo) {
        Result<List<DriverTruckAppVo>> result = truckFeign.driverTruckList(userNo);
        if (!result.succeed() || CollectionUtil.isEmpty(result.getData())) {
            throw new ServiceSystemException(PerformanceResultEnum.DATA_NOT_FIND);
        }
        List<String> truckList = result.getData().stream().map(DriverTruckAppVo::getTruckNo).collect(Collectors.toList());

        LocalDateTime now = LocalDateTime.now();

        List<OrderGoodsTruckBind> list = orderGoodsTruckBindDao.getCancelOrderGoods(truckList,
                DateUtils.formatDateTime(now.plusDays(-3), "yyyy-MM-dd HH:mm:ss").get(),
                DateUtils.formatDateTime(now, "yyyy-MM-dd HH:mm:ss").get());
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }

        return orderGoodsDao.getCancelOrderGoods(list.stream().map(OrderGoodsTruckBind::getTruckNo).collect(Collectors.toList()));
    }


    @Override
    public void updateCancelTruckBind(String orderGoodsNo) {
        List<OrderChild> arriveSendOrderChild = orderChildDao.selectArriveSendOrderChildGe(orderGoodsNo);
        List<String> truckList = null;
        if (CollectionUtils.isNotEmpty(arriveSendOrderChild)) {
            truckList = arriveSendOrderChild.stream().map(OrderChild::getTruckNo).collect(Collectors.toList());
        }
        orderGoodsTruckBindDao.updateOrderGoodsBindStatus(orderGoodsNo, OrderGoodsTruckBindEnum.Status.CANCEL.getCode(), truckList);

//            List<OrderGoodsTruckBind> truckBindList = orderGoodsTruckBindDao.selectCancelRecord(orderGoodsNo, truckList);
//            if (CollectionUtils.isNotEmpty(truckBindList)) {
//                for (OrderGoodsTruckBind bind : truckBindList) {
//                    goodsOrderTruckRecordComponent.deleteTruckRecord(orderGoodsNo, bind.getTruckNo());
//                }
//            }

    }
}
