package com.clx.performance.model.settle;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

/**
 * @author liruixin
 * Date 2023-10-13
 * Time 13:55
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("settlement_platform_account")
public class SettlementPlatformAccount  implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("card_holder")
    @ApiModelProperty("持卡人")
    private String cardHolder;

    @TableField("bank_name")
    @ApiModelProperty("银行名称")
    private String bankName;

    @TableField("bank_card_no")
    @ApiModelProperty("银行卡卡号")
    private String bankCardNo;

    @TableField("status")
    @ApiModelProperty("启用禁用状态 0-启用，1-禁用")
    private Integer status;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
