package com.clx.performance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.IntegralRecord;
import com.clx.performance.param.pc.pageIntegralStatisticsDetailParam;
import com.clx.performance.sqlProvider.IntegralRecordSqlProvider;
import com.clx.performance.vo.pc.IntegralRecordVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
* @Author: aiqinguo
* @Description: 积分记录
* @Date: 2023-10-9 11:52:22
* @Version: 1.0
*/

@Mapper
public interface IntegraRecordMapper extends BaseMapper<IntegralRecord> {

    /**
     * @see IntegralRecordSqlProvider#pageByParam(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.pc.pageIntegralStatisticsDetailParam)
     */
    @SelectProvider(type = IntegralRecordSqlProvider.class, method = "pageByParam")
    IPage<IntegralRecordVO> pageByParam(@Param("page") Page<IntegralRecordVO> page, @Param("param") pageIntegralStatisticsDetailParam param);

    @Select("<script>select sum(integral) from integral_record where " +
            " type in <foreach collection='list' item='item' open='(' separator=',' close=')'>#{item}</foreach> " +
            " and statistics_id = #{statisticsId}" +
            "</script>")
    Integer sumByStatisticsIdAndTypes(@Param("statisticsId") Integer statisticsId, @Param("list") List<Integer> typeList);

    @Select("select sum(integral) from integral_record where statistics_id = #{statisticsId} and type = #{type} and create_time >= #{beginTime} and create_time < #{endTime}")
    Integer sumByStatisticsIdAndTypeAndTime(@Param("statisticsId") Integer statisticsId,
                                        @Param("type") Integer type,
                                        @Param("beginTime")String beginTime,
                                        @Param("endTime")String endTime);

    @Select("select count(1) from integral_record where statistics_id = #{statisticsId} and type = #{type} and create_time >= #{beginTime} and create_time < #{endTime}")
    Integer countByStatisticsIdAndTypeAndTime(@Param("statisticsId") Integer statisticsId,
                                        @Param("type") Integer type,
                                        @Param("beginTime")String beginTime,
                                        @Param("endTime")String endTime);

}