package com.clx.performance.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.mapper.IntegraRecordMapper;
import com.clx.performance.model.IntegralRecord;
import com.clx.performance.param.pc.pageIntegralStatisticsDetailParam;
import com.clx.performance.vo.pc.IntegralRecordVO;
import com.msl.common.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 积分记录
 * @Date: 2023-10-9 11:55:36
 * @Version: 1.0
 */
public interface IntegralRecordDao extends BaseDao<IntegraRecordMapper, IntegralRecord, Integer> {

    IPage<IntegralRecordVO> pageByParam(pageIntegralStatisticsDetailParam param);

    Integer sumIntegral(@Param("statisticsId") Integer statisticsId);

    IntegralRecord selectByStatisticsIdAndType(@Param("statisticsId") Integer statisticsId, @Param("type") Integer type);
    Integer sumByStatisticsIdAndTypes(@Param("statisticsId") Integer statisticsId, @Param("list") List<Integer> typeList);

    Integer sumByStatisticsIdAndTypeAndTime(@Param("statisticsId") Integer statisticsId,
                                            @Param("type") Integer type,
                                            @Param("beginTime")String beginTime,
                                            @Param("endTime")String endTime);
    Integer countByStatisticsIdAndTypeAndTime(@Param("statisticsId") Integer statisticsId,
                                            @Param("type") Integer type,
                                            @Param("beginTime")String beginTime,
                                            @Param("endTime")String endTime);

    List<IntegralRecord> listByStatisticsDateAndTruckNoList(@Param("statisticsDate") String statisticsDate, @Param("list") List<String> truckNoList);

}
