package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.driver.PageCarrierSettlementDriverDetailParam;
import com.clx.performance.service.settle.SettlementDriverDetailService;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementDriverDetailVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/settlementDriverDetail")
@Validated
@Api(tags = "承运端-计费管理")
@AllArgsConstructor
public class CarrierSettlementDriverDetailController {

    private final SettlementDriverDetailService settlementDriverDetailService;


    @ApiOperation(value = "运单计费列表（车主）",notes = "<br>By:刘海泉")
    @PostMapping("/pageSettlementDriverDetail")
    @UnitCovert(param = false)
    public Result<PageData<CarrierPageSettlementDriverDetailVO>> pageSettlementDriverDetail(@RequestBody @Validated PageCarrierSettlementDriverDetailParam param) {
        IPage<CarrierPageSettlementDriverDetailVO> page = settlementDriverDetailService.pageSettlementDriverDetail(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }


}
