package com.clx.performance.controller.pc;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.OrderGoodsLogParam;
import com.clx.performance.service.OrderGoodsLogService;
import com.clx.performance.vo.pc.OrderGoodsLogVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @ClassName GoodsOrderController
 * @Description
 * @Author kavin
 * @Date 2023/9/17 17:16
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping("/pc/goodsOrderLog")
@Validated
@AllArgsConstructor
@Api(tags = "PC-货单日志")
public class OrderGoodsLogController {

    OrderGoodsLogService orderGoodsLogService;


    @ApiOperation(value = "货单日志列表", notes = "<br>By:刘海泉")
    @PostMapping("/pageOrderGoodsList")
    public Result<PageData<OrderGoodsLogVO>> pageOrderGoodsLog(@RequestBody @Validated OrderGoodsLogParam param) {
        IPage<OrderGoodsLogVO> page = orderGoodsLogService.pageOrderGoodsLog(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


}
