package com.clx.performance.controller.feign;

import com.clx.performance.param.feign.OrderAdjustTonnageDownParam;
import com.clx.performance.service.breakcontract.BreakContractSettlementOwnerService;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Slf4j
@RestController
@RequestMapping(value="/feign/breakContract")
@Validated
@Api(tags = "货主违约结算单")
@AllArgsConstructor
public class BreakContractSettlementOwnerFeignController {

    private final BreakContractSettlementOwnerService breakContractSettlementOwnerService;


    @ApiOperation(value = "货主订单吨数下调自动保存违约结算单")
    @PostMapping("/saveSettlementOwnerForTonnageDown")
    Result<Void> saveBreakContractSettlementOwner(@RequestBody @Validated OrderAdjustTonnageDownParam param){
        breakContractSettlementOwnerService.saveSettlementOwnerForTonnageDown(param);
        return Result.ok();
    }



}
