package com.clx.performance.controller.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.collect.*;
import com.clx.performance.service.collect.CollectLineReportService;
import com.clx.performance.vo.pc.collect.CollectLineReportVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/app/driver/collect/line")
@Validated
@Api(tags = "APP-线路上报")
@AllArgsConstructor
public class AppDriverCollectLineReportController {

    private final CollectLineReportService collectLineReportService;

    @ApiOperation(value = "上报货源地情况", notes = "<br>By:艾庆国")
    @PostMapping("/saveSendAddressReport")
    public Result<Void> saveSendAddressReport(@RequestBody @Validated CollectLineReportSendAddressSaveParam param) {
        collectLineReportService.saveSendAddressReport(param);

        return Result.ok();
    }

    @ApiOperation(value = "上报异常", notes = "<br>By:艾庆国")
    @PostMapping("/saveAbnormalReport")
    public Result<Void> saveAbnormalReport(@RequestBody @Validated CollectLineReportAbnormalSaveParam param) {
        collectLineReportService.saveAbnormalReport(param);

        return Result.ok();
    }

    @Deprecated
    @ApiOperation(value = "上报异常无法到达货源地", notes = "<br>By:艾庆国")
    @PostMapping("/saveSendAddressAbnormalReport")
    public Result<Void> saveSendAddressAbnormalReport(@RequestBody @Validated CollectLineReportSendAddressAbnormalSaveParam param) {
        collectLineReportService.saveSendAddressAbnormalReport(param);

        return Result.ok();
    }
    @Deprecated
    @ApiOperation(value = "上报异常无法装货", notes = "<br>By:艾庆国")
    @PostMapping("/saveLoadAbnormalReport")
    public Result<Void> saveLoadAbnormalReport(@RequestBody @Validated CollectLineReportLoadAbnormalSaveParam param) {
        collectLineReportService.saveLoadAbnormalReport(param);

        return Result.ok();
    }
    @Deprecated
    @ApiOperation(value = "上报异常无法到达目的地", notes = "<br>By:艾庆国")
    @PostMapping("/saveReceiveAddressAbnormalReport")
    public Result<Void> saveReceiveAddressAbnormalReport(@RequestBody @Validated CollectLineReportReceiveAddressAbnormalSaveParam param) {
        collectLineReportService.saveReceiveAddressAbnormalReport(param);

        return Result.ok();
    }
    @Deprecated
    @ApiOperation(value = "上报装卸车异常", notes = "<br>By:艾庆国")
    @PostMapping("/saveLoadUnloadAbnormalReport")
    public Result<Void> saveLoadUnloadAbnormalReport(@RequestBody @Validated CollectLineReportLoadUnloadAbnormalSaveParam param) {
        collectLineReportService.saveLoadUnloadAbnormalReport(param);

        return Result.ok();
    }


    @ApiOperation(value = "上报异常没有接单原因", notes = "<br>By:艾庆国")
    @PostMapping("/saveNoTakeOrderAbnormalReport")
    public Result<Void> saveNoTakeOrderAbnormalReport(@RequestBody @Validated CollectLineReportNoTakeOrderAbnormalSaveParam param) {
        collectLineReportService.saveNoTakeOrderAbnormalReport(param);

        return Result.ok();
    }


    @ApiOperation(value = "上报其它情况", notes = "<br>By:艾庆国")
    @PostMapping("/saveOtherReport")
    public Result<Void> saveOtherReport(@RequestBody @Validated CollectLineReportOtherSaveParam param) {
        collectLineReportService.saveOtherReport(param);

        return Result.ok();
    }

    @ApiOperation(value = "上报煤炭质量", notes = "<br>By:艾庆国")
    @PostMapping("/saveQualityReport")
    public Result<Void> saveQualityReport(@RequestBody @Validated CollectLineReportQualitySaveParam param) {
        collectLineReportService.saveQualityReport(param);

        return Result.ok();
    }

    @ApiOperation(value = "查询线路上报详情", notes = "<br>By:艾庆国")
    @GetMapping("/getReportInfo")
    public Result<CollectLineReportVO> getReportInfo(Integer id) {

        return Result.ok(collectLineReportService.getReportInfo(id));
    }

    @ApiOperation(value = "分页查询线路上报列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageLineReport")
    @UnitCovert(param = false)
    public Result<PageData<CollectLineReportVO>> pageLineReport(@RequestBody @Validated PageCollectLineReportParam param) {
        IPage<CollectLineReportVO> page = collectLineReportService.pageLineReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
