package com.clx.performance.vo.pc;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;


@Getter
@Setter
@NoArgsConstructor
public class OwnerAccountRunningWaterRecordVO {

    /**
     * id
     */
    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("流水号")
    private Long runningWaterNo;
    /**
     * 货主编码
     */
    @ApiModelProperty("货主编码")
    private Long ownerUserNo;
    /**
     * 货主名称
     */
    @ApiModelProperty("货主名称")
    private String ownerUserName;
    /**
     * 联系电话
     */
    @ApiModelProperty("联系电话")
    private String mobile;
    /**
     * 账户类型
     */
    @ApiModelProperty("账户类型")
    private Integer accountType;

    /**
     * 关联数据主键ID
     */
    @ApiModelProperty("关联数据主键ID")
    private Integer relationId;
    /**
     * 流水类型
     */
    @ApiModelProperty("流水类型 10：充值 20：冻结 30：解冻 40：提现冻结 50：提现成功 60：扣除 70：提现失败")
    private Integer runningWaterType;
    /**
     * 订单ID
     */
    @ApiModelProperty("订单ID")
    private Integer orderId;
    /**
     * 订单编号
     */
    @ApiModelProperty("订单编号")
    private String orderNo;
    /**
     * 运单ID
     */
    @ApiModelProperty("运单ID")
    private Integer orderChildId;
    /**
     * 运单编号
     */
    @ApiModelProperty("运单编号")
    private String orderChildNo;
    /**
     * 变动金额
     */
    @ApiModelProperty("变动金额")
    @MoneyOutConvert
    private BigDecimal alterationBalance;
    /**
     * 冻结金额
     */
    @ApiModelProperty("冻结金额")
    @MoneyOutConvert
    private BigDecimal frozenBalance;
    /**
     * 可用余额
     */
    @ApiModelProperty("可用余额")
    @MoneyOutConvert
    private BigDecimal usableBalance;
    /**
     * 账户余额
     */
    @ApiModelProperty("账户余额")
    @MoneyOutConvert
    private BigDecimal accountBalance;

    @ApiModelProperty("扣除金额")
    @MoneyOutConvert
    private BigDecimal takeOutBalance;
    /**
     * 操作人
     */
    @ApiModelProperty("操作人")
    private String createBy;
    /**
     * 操作时间
     */
    @ApiModelProperty("操作时间")
    private String createTime;

}