package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OrderGoodsTruckBindEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {

        NORMAL(1, "正常"),

        CANCEL(2, "取消"),
        GET(3, "已接单"),
        EXPIRE(4, "已失效"),
        SUCCESS(5, "结束")

        ;

        private final int code;
        private final String name;

        public static Optional<Status> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }



}
