package com.clx.performance.service.vehiclewarn;

import com.clx.performance.model.OrderChild;
import com.clx.performance.model.vehiclewarn.VehicleWarnChild;
import com.clx.performance.model.vehiclewarn.VehicleWarnConfig;
import com.clx.performance.model.vehiclewarn.VehicleWarnInfo;

import java.math.BigDecimal;

public interface VehicleWarnCommonService {
    void vehicleWarnInfoUpdate(OrderChild orderChild, VehicleWarnInfo vehicleWarnInfo, VehicleWarnConfig vehicleWarnConfig);

    boolean suspendCheck(VehicleWarnChild vehicleWarnChild, Integer warnConfigId);

    BigDecimal[] getCurrentPosition(String truckNo, Long userNo);

    int getNeedTime(BigDecimal originLongitude, BigDecimal originLatitude,
                    BigDecimal destinationLongitude, BigDecimal destinationLatitude);
    int getNeedTime(BigDecimal[] currentPosition,
                    BigDecimal destinationLongitude, BigDecimal destinationLatitude);

    int getNeedDistance(BigDecimal[] currentPosition,
                        BigDecimal destinationLongitude, BigDecimal destinationLatitude);

    Integer getDistance(BigDecimal[] currentPosition,
                    BigDecimal destinationLongitude, BigDecimal destinationLatitude);
}
