package com.clx.performance.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@Getter
@Setter
@ConfigurationProperties(prefix = "clx.message")
public class ClxMessageConfig {

    //应用ID
    private Long appId;

    //渠道ID
    private Integer channelId;

    //短信验证码模板
    private String captchaTemplateCode;

    //订单支付短信模板
    private String orderPayTemplateCode;

    //转账支付-借款单短信模板
    private String borrowTemplateCode;

    //转账支付-还款单短信模板
    private String repaymentTemplateCode;

    //车辆报警短信模板
    private String vehicleWarnTemplateCode;
    //车辆报警渠道id
    private Integer vehicleWarnChannelId;
    //线路报警短信模板
    private String lineWarnTemplateCode;

}
