package com.clx.performance.sqlProvider.vehiclewarn;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnConfigParam;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class VehicleWarnConfigSqlProvider {

    private static final String TABLE = "vehicle_warn_config";

    public String pageByParam(@Param("page") Page page, @Param("param") PageVehicleWarnConfigParam param) {

        return new SQL(){{

            SELECT("*");
            FROM(TABLE);

            if (StringUtils.isNotBlank(param.getWarnName())) {WHERE("warn_name = #{param.warnName}");}
            if (Objects.nonNull(param.getWarnType())) {WHERE("warn_type = #{param.warnType}");}
            if (Objects.nonNull(param.getWarnLevel())) {WHERE("warn_level = #{param.warnLevel}");}
            if (Objects.nonNull(param.getStatus())) {WHERE("status = #{param.status}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("create_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("create_time <= #{param.endTime}");}

            ORDER_BY("id desc");
        }}.toString();
    }

}
