package com.clx.performance.service.impl.vehiclewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.vehiclewarn.VehicleWarnConfigDao;
import com.clx.performance.enums.ResultEnum;
import com.clx.performance.enums.vehiclewarn.VehicleWarnConfigEnum;
import com.clx.performance.model.vehiclewarn.VehicleWarnConfig;
import com.clx.performance.param.pc.vehiclewarn.*;
import com.clx.performance.service.vehiclewarn.VehicleWarnConfigService;
import com.clx.performance.struct.vehiclewarn.VehicleWarnConfigStruct;
import com.clx.performance.vo.pc.vehiclewarn.VehicleWarnConfigVO;
import com.msl.common.base.Optional;
import com.msl.common.exception.ServiceSystemException;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Objects;

@Slf4j
@Service
public class VehicleWarnConfigServiceImpl implements VehicleWarnConfigService {

    @Autowired
    private VehicleWarnConfigDao vehicleWarnConfigDao;

    @Autowired
    private VehicleWarnConfigStruct vehicleWarnConfigStruct;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveConfig(VehicleWarnConfigAddParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();

        Optional<VehicleWarnConfig> optional = vehicleWarnConfigDao.findByName(param.getWarnName());
        if (optional.isPresent()){
            throw new ServiceSystemException(ResultEnum.VEHICLE_WARN_CONFIG_EXIST);
        }

        VehicleWarnConfig vehicleWarnConfig = new VehicleWarnConfig();
        vehicleWarnConfig.setWarnName(param.getWarnName());
        vehicleWarnConfig.setWarnType(param.getWarnType());
        vehicleWarnConfig.setWarnLevel(param.getWarnLevel());

        vehicleWarnConfig.setInterval(param.getInterval());
        vehicleWarnConfig.setTimeoutRatio(param.getTimeoutRatio());
        vehicleWarnConfig.setLongitude(param.getLongitude());
        vehicleWarnConfig.setLatitude(param.getLatitude());
        vehicleWarnConfig.setRadius(param.getRadius());
        vehicleWarnConfig.setCreateBy(loginUserInfo.getUserName());

        vehicleWarnConfigDao.saveEntity(vehicleWarnConfig);

    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateConfig(VehicleWarnConfigUpdateParam param) {
        VehicleWarnConfig vehicleWarnConfig = vehicleWarnConfigDao.findById(param.getId()).orElseThrow(ResultEnum.DATA_NOT_FIND);
        if (!Objects.equals(vehicleWarnConfig.getWarnName(), param.getWarnName())){
            Optional<VehicleWarnConfig> optional = vehicleWarnConfigDao.findByName(param.getWarnName());
            if (optional.isPresent()){
                throw new ServiceSystemException(ResultEnum.VEHICLE_WARN_CONFIG_EXIST);
            }
        }

        vehicleWarnConfig.setWarnName(param.getWarnName());
        vehicleWarnConfig.setWarnType(param.getWarnType());
        vehicleWarnConfig.setWarnLevel(param.getWarnLevel());

        vehicleWarnConfig.setInterval(param.getInterval());
        vehicleWarnConfig.setTimeoutRatio(param.getTimeoutRatio());
        vehicleWarnConfig.setLongitude(param.getLongitude());
        vehicleWarnConfig.setLatitude(param.getLatitude());
        vehicleWarnConfig.setRadius(param.getRadius());

        vehicleWarnConfigDao.updateConfig(vehicleWarnConfig);
    }
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateStatus(VehicleWarnConfigStatusUpdateParam param) {
        VehicleWarnConfig vehicleWarnConfig = vehicleWarnConfigDao.findById(param.getId()).orElseThrow(ResultEnum.DATA_NOT_FIND);

        vehicleWarnConfig.setStatus(param.getStatus());
        vehicleWarnConfigDao.updateStatus(vehicleWarnConfig);

    }

    @Override
    public void deleteConfig(VehicleWarnConfigDeleteUpdateParam param) {
        VehicleWarnConfig vehicleWarnConfig = vehicleWarnConfigDao.findById(param.getId()).orElseThrow(ResultEnum.DATA_NOT_FIND);

        vehicleWarnConfig.setDeleteStatus(VehicleWarnConfigEnum.DeleteStatus.YES.getCode());
        vehicleWarnConfigDao.updateDelete(vehicleWarnConfig);
    }

    @Override
    public VehicleWarnConfigVO getConfig(Integer id) {

        return vehicleWarnConfigStruct.convert(vehicleWarnConfigDao.findById(id).orNull());
    }

    @Override
    public IPage<VehicleWarnConfigVO> pageConfig(PageVehicleWarnConfigParam param) {

        return vehicleWarnConfigStruct.convertPage(vehicleWarnConfigDao.pageByParam(param));
    }
}
