package com.clx.performance.dto.payment;

import com.fasterxml.jackson.annotation.JsonGetter;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 
 * @author 胡宁宁
 * @date 2023年11月12日
 * @description
 */

public class WalletResidueDTO {
	//余额
	@ApiModelProperty(value = "余额", dataType = "double", example = "11.10")
	private Long residue;
	//冻结的资金
	@ApiModelProperty(value = "冻结的资金", dataType = "double", example = "11.10")
	private Long frozen;
	//保证金
	@ApiModelProperty(value = "保证金", dataType = "double", example = "11.10")
	private Double deposit;
	//状态0锁定1正常2异常
	@ApiModelProperty(value = "状态0锁定1正常2异常", dataType = "int", example = "1")
	private Integer status;
	//是否设置交易密码0没有1有
	@ApiModelProperty(value = "是否设置交易密码0没有1有", dataType = "String", example = "1")
	private String pwd;
	
	public Long getResidue() {
		return residue;
	}
	public void setResidue(Long residue) {
		this.residue = residue;
	}
	public Long getFrozen() {
		return frozen;
	}
	public void setFrozen(Long frozen) {
		this.frozen = frozen;
	}
	public Integer getStatus() {
		return status;
	}
	public void setStatus(Integer status) {
		this.status = status;
	}
	public String getPwd() {
		return pwd;
	}
	public void setPwd(String pwd) {
		this.pwd = pwd;
	}
	@JsonGetter(value="frozen")
	public BigDecimal frozenFormat() {
		return new BigDecimal(new Double(this.frozen)/100);
	}
	@JsonGetter(value="residue")
	public Double residueFormat() {
		return new Double(this.residue)/100;
	}
	@JsonGetter(value="deposit")
	public Double depositFormat() {
		return new Double(this.deposit)/100;
	}

	public Double getDeposit() {
		return deposit;
	}

	public void setDeposit(Double deposit) {
		this.deposit = deposit;
	}

	@Override
	public String toString() {
		return "WalletDTO [residue=" + residue + ", frozen=" + frozen
				+ ", status=" + status + "]";
	}
	
}
