package com.clx.performance.vo.pc.vehiclewarn;

import com.clx.performance.enums.vehiclewarn.VehicleWarnConfigEnum;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 车辆预警配置
* @Date: 2024/04/25 14:09:40
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
public class VehicleWarnConfigVO {

    @ApiModelProperty(value = "id", example = "1")
    private Integer id;
    @ApiModelProperty(value = "预警方案名称", example = "方案1")
    private String warnName;
    @ApiModelProperty(value = "预警类型: 1到达货源地延误 2前往货源地超时 3到达目的地延误 4前往目的地超时 5停留超时 6敏感区停留 7装车超时 8卸车超时 9运单延误", example = "1")
    private Integer warnType;
    @ApiModelProperty(value = "预警类型", example = "1")
    private String warnTypeMsg;
    public String getWarnTypeMsg() {
        return VehicleWarnConfigEnum.WarnType.getMsgByCode(warnType);
    }
    @ApiModelProperty(value = "预警级别: 1一级 2二级 3三级", example = "1")
    private Integer warnLevel;
    @ApiModelProperty(value = "预警级别", example = "一级")
    private String warnLevelMsg;
    public String getWarnLevelMsg() {
        if (warnLevel == 1) {return "一级";}
        if (warnLevel == 2) {return "二级";}
        if (warnLevel == 3) {return "三级";}
        return null;
    }
    @ApiModelProperty(value = "预警间隔（小时）", example = "1.2")
    private BigDecimal interval;
    @ApiModelProperty(value = "超时比例（%）", example = "12.3")
    private BigDecimal timeoutRatio;
    @ApiModelProperty(value = "经度", example = "123.45")
    private BigDecimal longitude;
    @ApiModelProperty(value = "纬度", example = "12.34")
    private BigDecimal latitude;
    @ApiModelProperty(value = "半径（米）", example = "123")
    private Integer radius;

    @ApiModelProperty(value = "状态：1启用 2禁用", example = "1")
    private Integer status;
    @ApiModelProperty(value = "状态：1启用 2禁用", example = "启用")
    private String statusMsg;
    public String getStatusMsg() {
        return VehicleWarnConfigEnum.Status.getMsgByCode(status);
    }
    @ApiModelProperty(value = "创建人", example = "")
    private String createBy;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;
    @ApiModelProperty(value = "修改时间", example = "")
    private String modifiedTime;

}