package com.clx.performance.param.pc.vehiclewarn;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Getter
@Setter
@NoArgsConstructor
public class VehicleWarnConfigUpdateParam {

    @ApiModelProperty(value = "id", example = "1")
    @NotNull(message = "id不能为空")
    private Integer id;

    @ApiModelProperty(value = "预警方案名称", example = "方案1")
    @NotBlank(message = "预警方案名称不能为空")
    private String warnName;
    @ApiModelProperty(value = "预警类型", example = "1")
    @NotNull(message = "预警类型不能为空")
    private Integer warnType;
    @ApiModelProperty(value = "预警级别: 1一级 2二级 3三级", example = "1")
    @NotNull(message = "预警级别不能为空")
    private Integer warnLevel;

    @ApiModelProperty(value = "预警间隔（小时）", example = "1.2")
    private BigDecimal interval;
    @ApiModelProperty(value = "超时比例（%）", example = "12.3")
    private BigDecimal timeoutRatio;
    @ApiModelProperty(value = "经度", example = "123.45")
    private BigDecimal longitude;
    @ApiModelProperty(value = "纬度", example = "12.34")
    private BigDecimal latitude;
    @ApiModelProperty(value = "半径（米）", example = "123")
    private Integer radius;

}
