package com.clx.performance.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.constant.RabbitKeyIntegralConstants;
import com.clx.performance.param.mq.IntegralTruckProtectionCancelMqParam;
import com.clx.performance.service.IntegralMqHandlerService;
import com.clx.performance.common.MqWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 新车保护取消 mq
 * @Date: 2023-10-12 19:27:58
 * @Version: 1.0
 */
@Slf4j
@Component
public class IntegralTruckProtectionCancelListener {

    @Autowired
    private IntegralMqHandlerService integralMqHandlerService;

    @RabbitListener(queues = RabbitKeyIntegralConstants.INTEGRAL_TRUCK_PROTECTION_CANCEL_QUEUE)
    public void process(Message message) {
        try{
            log.info("司机积分-新车保护取消, message:{}", new String(message.getBody()));
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<IntegralTruckProtectionCancelMqParam>>(){}).getData());
        }catch (Exception e){
            log.info("司机积分-新车保护取消 失败",e);
        }
    }

    private void process(IntegralTruckProtectionCancelMqParam mq){

        integralMqHandlerService.truckProtectionCancel(mq);

    }
}
