/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.pqc.crypto.sphincs;

import com.nbcb.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.nbcb.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.nbcb.bouncycastle.crypto.Digest;
import com.nbcb.bouncycastle.crypto.KeyGenerationParameters;
import com.nbcb.bouncycastle.pqc.crypto.sphincs.HashFunctions;
import com.nbcb.bouncycastle.pqc.crypto.sphincs.SPHINCS256KeyGenerationParameters;
import com.nbcb.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.nbcb.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.nbcb.bouncycastle.pqc.crypto.sphincs.Tree;
import java.security.SecureRandom;

public class SPHINCS256KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private Digest treeDigest;

    @Override
    public void init(KeyGenerationParameters param) {
        this.random = param.getRandom();
        this.treeDigest = ((SPHINCS256KeyGenerationParameters)param).getTreeDigest();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Tree.leafaddr a = new Tree.leafaddr();
        byte[] sk = new byte[1088];
        this.random.nextBytes(sk);
        byte[] pk = new byte[1056];
        System.arraycopy(sk, 32, pk, 0, 1024);
        a.level = 11;
        a.subtree = 0L;
        a.subleaf = 0L;
        HashFunctions hs = new HashFunctions(this.treeDigest);
        Tree.treehash(hs, pk, 1024, 5, sk, a, pk, 0);
        return new AsymmetricCipherKeyPair(new SPHINCSPublicKeyParameters(pk), new SPHINCSPrivateKeyParameters(sk));
    }
}

