/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.jcajce.provider.asymmetric.ec;

import com.nbcb.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.nbcb.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.nbcb.bouncycastle.asn1.x9.X9ECParameters;
import com.nbcb.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.nbcb.bouncycastle.crypto.CryptoServicesRegistrar;
import com.nbcb.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.nbcb.bouncycastle.crypto.params.ECDomainParameters;
import com.nbcb.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.nbcb.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.nbcb.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.nbcb.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import com.nbcb.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import com.nbcb.bouncycastle.jcajce.provider.asymmetric.ec.ECUtils;
import com.nbcb.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.nbcb.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.nbcb.bouncycastle.jce.provider.BouncyCastleProvider;
import com.nbcb.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import com.nbcb.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.nbcb.bouncycastle.math.ec.ECCurve;
import com.nbcb.bouncycastle.math.ec.ECPoint;
import com.nbcb.bouncycastle.util.Integers;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Hashtable;
import java.util.Map;

public abstract class KeyPairGeneratorSpi
extends KeyPairGenerator {
    public KeyPairGeneratorSpi(String algorithmName) {
        super(algorithmName);
    }

    public static class ECMQV
    extends EC {
        public ECMQV() {
            super("ECMQV", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class EC
    extends KeyPairGeneratorSpi {
        ECKeyGenerationParameters param;
        ECKeyPairGenerator engine = new ECKeyPairGenerator();
        Object ecParams = null;
        int strength = 239;
        SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
        boolean initialised = false;
        String algorithm;
        ProviderConfiguration configuration;
        private static Hashtable ecParameters = new Hashtable();

        public EC() {
            super("EC");
            this.algorithm = "EC";
            this.configuration = BouncyCastleProvider.CONFIGURATION;
        }

        public EC(String algorithm, ProviderConfiguration configuration) {
            super(algorithm);
            this.algorithm = algorithm;
            this.configuration = configuration;
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
            ECGenParameterSpec ecParams = (ECGenParameterSpec)ecParameters.get(Integers.valueOf(strength));
            if (ecParams == null) {
                throw new InvalidParameterException("unknown key size.");
            }
            try {
                this.initialize(ecParams, random);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new InvalidParameterException("key size not configurable.");
            }
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params == null) {
                com.nbcb.bouncycastle.jce.spec.ECParameterSpec implicitCA = this.configuration.getEcImplicitlyCa();
                if (implicitCA == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
                }
                this.ecParams = null;
                this.param = this.createKeyGenParamsBC(implicitCA, random);
            } else if (params instanceof com.nbcb.bouncycastle.jce.spec.ECParameterSpec) {
                this.ecParams = params;
                this.param = this.createKeyGenParamsBC((com.nbcb.bouncycastle.jce.spec.ECParameterSpec)params, random);
            } else if (params instanceof ECParameterSpec) {
                this.ecParams = params;
                this.param = this.createKeyGenParamsJCE((ECParameterSpec)params, random);
            } else if (params instanceof ECGenParameterSpec) {
                this.initializeNamedCurve(((ECGenParameterSpec)params).getName(), random);
            } else if (params instanceof ECNamedCurveGenParameterSpec) {
                this.initializeNamedCurve(((ECNamedCurveGenParameterSpec)params).getName(), random);
            } else {
                throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
            }
            this.engine.init(this.param);
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.initialize(this.strength, new SecureRandom());
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
            if (this.ecParams instanceof com.nbcb.bouncycastle.jce.spec.ECParameterSpec) {
                com.nbcb.bouncycastle.jce.spec.ECParameterSpec p = (com.nbcb.bouncycastle.jce.spec.ECParameterSpec)this.ecParams;
                BCECPublicKey pubKey = new BCECPublicKey(this.algorithm, pub, p, this.configuration);
                return new KeyPair(pubKey, new BCECPrivateKey(this.algorithm, priv, pubKey, p, this.configuration));
            }
            if (this.ecParams == null) {
                return new KeyPair(new BCECPublicKey(this.algorithm, pub, this.configuration), new BCECPrivateKey(this.algorithm, priv, this.configuration));
            }
            ECParameterSpec p = (ECParameterSpec)this.ecParams;
            BCECPublicKey pubKey = new BCECPublicKey(this.algorithm, pub, p, this.configuration);
            return new KeyPair(pubKey, new BCECPrivateKey(this.algorithm, priv, pubKey, p, this.configuration));
        }

        protected ECKeyGenerationParameters createKeyGenParamsBC(com.nbcb.bouncycastle.jce.spec.ECParameterSpec p, SecureRandom r) {
            return new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH()), r);
        }

        protected ECKeyGenerationParameters createKeyGenParamsJCE(ECParameterSpec p, SecureRandom r) {
            ECCurve curve = EC5Util.convertCurve(p.getCurve());
            ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
            BigInteger n = p.getOrder();
            BigInteger h = BigInteger.valueOf(p.getCofactor());
            ECDomainParameters dp = new ECDomainParameters(curve, g, n, h);
            return new ECKeyGenerationParameters(dp, r);
        }

        protected ECNamedCurveSpec createNamedCurveSpec(String curveName) throws InvalidAlgorithmParameterException {
            X9ECParameters p = ECUtils.getDomainParametersFromName(curveName);
            if (p == null) {
                try {
                    Map extraCurves;
                    p = ECNamedCurveTable.getByOID(new ASN1ObjectIdentifier(curveName));
                    if (p == null && (p = (X9ECParameters)(extraCurves = this.configuration.getAdditionalECParameters()).get(new ASN1ObjectIdentifier(curveName))) == null) {
                        throw new InvalidAlgorithmParameterException("unknown curve OID: " + curveName);
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
                }
            }
            byte[] seed = null;
            return new ECNamedCurveSpec(curveName, p.getCurve(), p.getG(), p.getN(), p.getH(), seed);
        }

        protected void initializeNamedCurve(String curveName, SecureRandom random) throws InvalidAlgorithmParameterException {
            ECNamedCurveSpec namedCurve = this.createNamedCurveSpec(curveName);
            this.ecParams = namedCurve;
            this.param = this.createKeyGenParamsJCE(namedCurve, random);
        }

        static {
            ecParameters.put(Integers.valueOf(192), new ECGenParameterSpec("prime192v1"));
            ecParameters.put(Integers.valueOf(239), new ECGenParameterSpec("prime239v1"));
            ecParameters.put(Integers.valueOf(256), new ECGenParameterSpec("prime256v1"));
            ecParameters.put(Integers.valueOf(224), new ECGenParameterSpec("P-224"));
            ecParameters.put(Integers.valueOf(384), new ECGenParameterSpec("P-384"));
            ecParameters.put(Integers.valueOf(521), new ECGenParameterSpec("P-521"));
        }
    }
}

