package com.clx.performance.dto.vehiclewarn;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class VehicleWarnCommonInfoDTO {

    String childNo;                 //运单
    BigDecimal[] currentPosition;   //当前位置

    Integer sendAddressDistance;    //距货源地址距离
    Integer receiveAddressDistance; //距目的地址距离

    Integer sendAddressTime;        //距货源地址时间
    Integer receiveAddressTime;     //距目的地址时间

    Boolean suspendStatus;          //是否暂停 0:未暂停 1:暂停

    private LocalDateTime lastArriveSendTime;       //最晚到达货源地时间
    private LocalDateTime lastArriveReceiveTime;    //最晚到达目的地时间

    LocalDateTime currentTime;      //当前时间

    private LocalDateTime transportEndTime;    //拉运结束时间

}
