package com.clx.performance.vo.pc;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
@Getter
@Setter
@Accessors(chain = true)
public class NetworkDriverAccountVO {

    private Integer id;

    @ApiModelProperty("司机编码")
    private String driverUserNo;

    @ApiModelProperty("司机名称")
    private String driverUserName;

    @ApiModelProperty("联系电话")
    private String mobile;

    @ApiModelProperty("账户余额")
    @MoneyOutConvert
    private BigDecimal accountBalance;

    @ApiModelProperty("可用余额")
    @MoneyOutConvert
    private BigDecimal usableBalance;

    @ApiModelProperty("冻结余额")
    @MoneyOutConvert
    private BigDecimal frozenBalance;

    @ApiModelProperty("钱包code")
    private String walletCode;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建时间")
    private String createTime;

    @ApiModelProperty("修改时间")
    private String modifiedTime;

}
