package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum PendingOrderWayStatusEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {

        GK(1, "GK"),

        DX(2, "DX")
        ;

        private final Integer code;
        private final String name;

        public static Optional<Status> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }
    }


}
