/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.x509.extension;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.x509.AuthorityKeyIdentifier;
import cn.com.infosec.asn1.x509.SubjectKeyIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.x509.extension.X509ExtensionUtil;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;

public class SubjectKeyIdentifierStructure
extends SubjectKeyIdentifier {
    private AuthorityKeyIdentifier authKeyID;

    public SubjectKeyIdentifierStructure(byte[] encodedValue) throws IOException {
        super((ASN1OctetString)X509ExtensionUtil.fromExtensionValue(encodedValue));
    }

    private static ASN1OctetString fromPublicKey(PublicKey pubKey) throws CertificateParsingException {
        try {
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(pubKey.getEncoded()).readObject());
            return (ASN1OctetString)new SubjectKeyIdentifier(info).toASN1Object();
        }
        catch (Exception e) {
            throw new CertificateParsingException("Exception extracting certificate details: " + e.toString());
        }
    }

    public SubjectKeyIdentifierStructure(PublicKey pubKey) throws CertificateParsingException {
        super(SubjectKeyIdentifierStructure.fromPublicKey(pubKey));
    }
}

