/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.signers;

import cn.com.infosec.crypto.AsymmetricBlockCipher;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.CryptoException;
import cn.com.infosec.crypto.DataLengthException;
import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.Signer;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.crypto.params.RSABlindingParameters;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import java.security.SecureRandom;

public class PSSSigner
implements Signer {
    public static final byte TRAILER_IMPLICIT = -68;
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private SecureRandom random;
    private int hLen;
    private int sLen;
    private int emBits;
    private byte[] salt;
    private byte[] mDash;
    private byte[] block;
    private byte trailer;

    public PSSSigner(AsymmetricBlockCipher cipher, Digest digest, int sLen) {
        this(cipher, digest, sLen, -68);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest digest, int sLen, byte trailer) {
        this.cipher = cipher;
        this.digest = digest;
        this.hLen = digest.getDigestSize();
        this.sLen = sLen;
        this.salt = new byte[sLen];
        this.mDash = new byte[8 + sLen + this.hLen];
        this.trailer = trailer;
    }

    public void init(boolean forSigning, CipherParameters param) {
        CipherParameters params;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom p = (ParametersWithRandom)param;
            params = p.getParameters();
            this.random = p.getRandom();
        } else {
            params = param;
            if (forSigning) {
                this.random = new SecureRandom();
            }
        }
        this.cipher.init(forSigning, params);
        RSAKeyParameters kParam = params instanceof RSABlindingParameters ? ((RSABlindingParameters)params).getPublicKey() : (RSAKeyParameters)params;
        this.emBits = kParam.getModulus().bitLength() - 1;
        this.block = new byte[(this.emBits + 7) / 8];
        this.reset();
    }

    private void clearBlock(byte[] block) {
        int i = 0;
        while (i != block.length) {
            block[i] = 0;
            ++i;
        }
    }

    public void update(byte b) {
        this.digest.update(b);
    }

    public void update(byte[] in, int off, int len) {
        this.digest.update(in, off, len);
    }

    public void reset() {
        this.digest.reset();
    }

    public byte[] generateSignature() throws CryptoException, DataLengthException {
        if (this.emBits < 8 * this.hLen + 8 * this.sLen + 9) {
            throw new DataLengthException("encoding error");
        }
        this.digest.doFinal(this.mDash, this.mDash.length - this.hLen - this.sLen);
        if (this.sLen != 0) {
            this.random.nextBytes(this.salt);
            System.arraycopy(this.salt, 0, this.mDash, this.mDash.length - this.sLen, this.sLen);
        }
        byte[] h = new byte[this.hLen];
        this.digest.update(this.mDash, 0, this.mDash.length);
        this.digest.doFinal(h, 0);
        this.block[this.block.length - this.sLen - 1 - this.hLen - 1] = 1;
        System.arraycopy(this.salt, 0, this.block, this.block.length - this.sLen - this.hLen - 1, this.sLen);
        byte[] dbMask = this.maskGeneratorFunction1(h, 0, h.length, this.block.length - this.hLen - 1);
        int i = 0;
        while (i != dbMask.length) {
            int n = i;
            this.block[n] = (byte)(this.block[n] ^ dbMask[i]);
            ++i;
        }
        this.block[0] = (byte)(this.block[0] & 255 >> this.block.length * 8 - this.emBits);
        System.arraycopy(h, 0, this.block, this.block.length - this.hLen - 1, this.hLen);
        this.block[this.block.length - 1] = this.trailer;
        byte[] b = this.cipher.processBlock(this.block, 0, this.block.length);
        this.clearBlock(this.block);
        return b;
    }

    public boolean verifySignature(byte[] signature) {
        if (this.emBits < 8 * this.hLen + 8 * this.sLen + 9) {
            return false;
        }
        this.digest.doFinal(this.mDash, this.mDash.length - this.hLen - this.sLen);
        try {
            byte[] b = this.cipher.processBlock(signature, 0, signature.length);
            System.arraycopy(b, 0, this.block, this.block.length - b.length, b.length);
        }
        catch (Exception e) {
            return false;
        }
        if (this.block[this.block.length - 1] != this.trailer) {
            this.clearBlock(this.block);
            return false;
        }
        byte[] dbMask = this.maskGeneratorFunction1(this.block, this.block.length - this.hLen - 1, this.hLen, this.block.length - this.hLen - 1);
        int i = 0;
        while (i != dbMask.length) {
            int n = i;
            this.block[n] = (byte)(this.block[n] ^ dbMask[i]);
            ++i;
        }
        this.block[0] = (byte)(this.block[0] & 255 >> this.block.length * 8 - this.emBits);
        i = 0;
        while (i != this.block.length - this.hLen - this.sLen - 2) {
            if (this.block[i] != 0) {
                this.clearBlock(this.block);
                return false;
            }
            ++i;
        }
        if (this.block[this.block.length - this.hLen - this.sLen - 2] != 1) {
            this.clearBlock(this.block);
            return false;
        }
        System.arraycopy(this.block, this.block.length - this.sLen - this.hLen - 1, this.mDash, this.mDash.length - this.sLen, this.sLen);
        this.digest.update(this.mDash, 0, this.mDash.length);
        this.digest.doFinal(this.mDash, this.mDash.length - this.hLen);
        i = this.block.length - this.hLen - 1;
        int j = this.mDash.length - this.hLen;
        while (j != this.mDash.length) {
            if ((this.block[i] ^ this.mDash[j]) != 0) {
                this.clearBlock(this.mDash);
                this.clearBlock(this.block);
                return false;
            }
            ++i;
            ++j;
        }
        this.clearBlock(this.mDash);
        this.clearBlock(this.block);
        return true;
    }

    private void ItoOSP(int i, byte[] sp) {
        sp[0] = (byte)(i >>> 24);
        sp[1] = (byte)(i >>> 16);
        sp[2] = (byte)(i >>> 8);
        sp[3] = (byte)(i >>> 0);
    }

    private byte[] maskGeneratorFunction1(byte[] Z, int zOff, int zLen, int length) {
        byte[] mask = new byte[length];
        byte[] hashBuf = new byte[this.hLen];
        byte[] C = new byte[4];
        int counter = 0;
        this.digest.reset();
        while (counter < length / this.hLen) {
            this.ItoOSP(counter, C);
            this.digest.update(Z, zOff, zLen);
            this.digest.update(C, 0, C.length);
            this.digest.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * this.hLen, this.hLen);
            ++counter;
        }
        if (counter * this.hLen < length) {
            this.ItoOSP(counter, C);
            this.digest.update(Z, zOff, zLen);
            this.digest.update(C, 0, C.length);
            this.digest.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * this.hLen, mask.length - counter * this.hLen);
        }
        return mask;
    }
}

