/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.x509.GeneralSubtree;
import java.util.Enumeration;
import java.util.Vector;

public class NameConstraints
extends ASN1Encodable {
    private ASN1Sequence permitted;
    private ASN1Sequence excluded;

    public NameConstraints(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1TaggedObject o = ASN1TaggedObject.getInstance(e.nextElement());
            switch (o.getTagNo()) {
                case 0: {
                    this.permitted = ASN1Sequence.getInstance(o, false);
                    break;
                }
                case 1: {
                    this.excluded = ASN1Sequence.getInstance(o, false);
                }
            }
        }
    }

    public NameConstraints(Vector permitted, Vector excluded) {
        if (permitted != null) {
            this.permitted = this.createSequence(permitted);
        }
        if (excluded != null) {
            this.excluded = this.createSequence(excluded);
        }
    }

    private DERSequence createSequence(Vector subtree) {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        Enumeration e = subtree.elements();
        while (e.hasMoreElements()) {
            vec.add((GeneralSubtree)e.nextElement());
        }
        return new DERSequence(vec);
    }

    public ASN1Sequence getPermittedSubtrees() {
        return this.permitted;
    }

    public ASN1Sequence getExcludedSubtrees() {
        return this.excluded;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.permitted != null) {
            v.add(new DERTaggedObject(false, 0, this.permitted));
        }
        if (this.excluded != null) {
            v.add(new DERTaggedObject(false, 1, this.excluded));
        }
        return new DERSequence(v);
    }
}

