package com.clx.performance.service.impl.vehiclewarn;

import com.alibaba.fastjson.JSON;
import com.clx.performance.common.MqDelay;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyVehicleWarnConstants;
import com.clx.performance.param.mq.vehiclewarn.VehicleWarnChildAddMqParam;
import com.clx.performance.param.mq.vehiclewarn.VehicleWarnTruckWarnMqParam;
import com.clx.performance.param.mq.vehiclewarn.VehicleWarnTruckWarnNoticeMqParam;
import com.clx.performance.service.vehiclewarn.VehicleWarnMqService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class VehicleWarnMqServiceImpl implements VehicleWarnMqService {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public void orderChildAdd(String childNo) {
        VehicleWarnChildAddMqParam mq = new VehicleWarnChildAddMqParam();
        mq.setChildNo(childNo);

        MqDelay delay = new MqDelay<>(RabbitKeyVehicleWarnConstants.DEFAULT_EXCHANGE,
                RabbitKeyVehicleWarnConstants.ORDER_CHILD_ADD_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyVehicleWarnConstants.DEFAULT_EXCHANGE,
                RabbitKeyVehicleWarnConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void truckWarn(String childNo) {
        VehicleWarnTruckWarnMqParam mq = new VehicleWarnTruckWarnMqParam();
        mq.setChildNo(childNo);

        MqDelay delay = new MqDelay<>(RabbitKeyVehicleWarnConstants.DEFAULT_EXCHANGE,
                RabbitKeyVehicleWarnConstants.TRUCK_WARN_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyVehicleWarnConstants.DEFAULT_EXCHANGE,
                RabbitKeyVehicleWarnConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void truckWarnNotice(Integer infoId) {
        VehicleWarnTruckWarnNoticeMqParam mq = new VehicleWarnTruckWarnNoticeMqParam();
        mq.setInfoId(infoId);

        MqDelay delay = new MqDelay<>(RabbitKeyVehicleWarnConstants.DEFAULT_EXCHANGE,
                RabbitKeyVehicleWarnConstants.TRUCK_WARN_NOTICE_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyVehicleWarnConstants.DEFAULT_EXCHANGE,
                RabbitKeyVehicleWarnConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

}
