package com.clx.performance.enums.loan;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum OwnerLoanAccountRunningWaterRecordEnum {
    ;


    @Getter
    @AllArgsConstructor
    public enum RunWaterType {
        APPROVE_WAIT(80, "借款"),
        APPROVE_FROZEN(90, "冻结"),
        APPROVE_CHILD_WRITE_OFF(100, "运单抵扣"),
        APPROVE_THAW(110, "解冻"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<OwnerLoanAccountRunningWaterRecordEnum.RunWaterType> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.code , code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(OwnerLoanAccountRunningWaterRecordEnum.RunWaterType::getMsg).orElse(null);
        }
    }

}
