package com.clx.performance.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @Author liumingchao
 * @Date 2023/7/21 13:22
 */
public class RoundingUtil {

    /**
     * 化验结果修约
     * @param value
     * @param scale
     * @return
     */
    public static BigDecimal round(BigDecimal value, int scale) {
        BigDecimal roundedValue = value.setScale(scale, RoundingMode.HALF_EVEN); // 四舍六入五单双

        // 获取末位有效数字后面的第一位数字
        int firstDigit = roundedValue.movePointRight(scale + 1).intValue() % 10;

        if (firstDigit > 5) {
            // 末位有效数字后面的第一位数字大于5，增加1
            roundedValue = roundedValue.add(BigDecimal.ONE);
        } else if (firstDigit < 5) {
            // 末位有效数字后面的第一位数字小于5，直接舍去
        } else {
            // 末位有效数字后面的第一位数字等于5
            int nextDigit = roundedValue.movePointRight(scale + 2).intValue() % 10;
            if (nextDigit != 0) {
                // 5后面的数字不全为0，增加1
                roundedValue = roundedValue.add(BigDecimal.ONE);
            } else {
                // 5后面的数字全部为0
                int leftDigit = roundedValue.movePointRight(scale).intValue() % 10;
                if (leftDigit % 2 != 0) {
                    // 5前面一位为奇数，增加1
                    roundedValue = roundedValue.add(BigDecimal.ONE);
                }
                // 5前面一位为偶数(包括0)，直接舍去
            }
        }

        // 特殊处理末位有效数字在个位或者十位的情况
        if (scale == 1 || scale == 0) {
            roundedValue = roundedValue.setScale(0, RoundingMode.DOWN);
        }

        return roundedValue.setScale(scale, RoundingMode.DOWN); // 设置最终结果的保留小数位数
    }


    private static int roundIntValue(int value, int scale) {
        // 获取末位有效数字后面的第一位数字
        int firstDigit = value % 10;

        if (firstDigit > 5) {
            // 末位有效数字后面的第一位数字大于5，增加1
            value = value + 10 - firstDigit;
        } else if (firstDigit < 5) {
            // 末位有效数字后面的第一位数字小于5，直接舍去
            value = value - firstDigit;
        } else {
            // 末位有效数字后面的第一位数字等于5
            int nextDigit = (value / 10) % 10;
            if (nextDigit != 0) {
                // 5后面的数字不全为0，增加1
                value = value + 10 - firstDigit;
            } else {
                // 5后面的数字全部为0
                int leftDigit = (value / 100) % 10;
                if (leftDigit % 2 != 0) {
                    // 5前面一位为奇数，增加1
                    value = value + 10 - firstDigit;
                } else {
                    // 5前面一位为偶数(包括0)，直接舍去
                    value = value - firstDigit;
                }
            }
        }

        // 修约到个位时需要将其他位数设为0
        if (scale == 0) {
            value = value - (value % 10);
        }

        return value;
    }
    public static void main(String[] args) {
        BigDecimal value1 = new BigDecimal("10.544500");
        BigDecimal value2 = new BigDecimal("15.542");
        BigDecimal value3 = new BigDecimal("5.500");
        BigDecimal value4 = new BigDecimal("2251.2251525");
        BigDecimal value5 = new BigDecimal("2251.525");

        System.out.println("修约后的值1: " + round(value1, 3)); // 输出：修约后的值1: 10.56
        System.out.println("修约后的值2: " + round(value2, 2)); // 输出：修约后的值2: 15.54
        System.out.println("修约后的值3: " + round(value3, 2)); // 输出：修约后的值3: 5.50
        System.out.println("修约后的值4: " + round(value4, 0)); // 输出：修约后的值4: 2.52
        System.out.println("修约后的值4: " + round(value4, 3)); // 输出：修约后的值4: 2.52
        System.out.println("修约后的值4: " + round(value4, 4)); // 输出：修约后的值4: 2.52
        System.out.println(roundIntValue(value5.setScale(0, RoundingMode.DOWN).intValue(), 0));
        System.out.println(roundIntValue(value5.setScale(0, RoundingMode.DOWN).intValue(), 1));
    }


}
