package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-10-16
 * Time 20:01
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_transfer_info")
public class OwnerTransferInfo implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("transfer_tip")
    @ApiModelProperty("转账提示信息")
    private String transferTip;

    @TableField("enterprise_name")
    @ApiModelProperty("企业信息")
    private String enterpriseName;

    @TableField("open_account_bank")
    @ApiModelProperty("开户行")
    private String openAccountBank;

    @TableField("open_account_bank_number")
    @ApiModelProperty("开户行银行代码")
    private String openAccountBankNumber;

    @TableField("account_number")
    @ApiModelProperty("账户账号")
    private String accountNumber;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
