package com.clx.performance.dto.payment;

import com.fasterxml.jackson.annotation.JsonGetter;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 *
 * @author 胡宁宁
 * @date 2023年11月12日
 * @description
 */
public class WalletResidueCardDTO extends WalletResidueDTO{
	@ApiModelProperty(value = "消费卡余额", dataType = "double", example = "11.10")
	private Long cardResidue;
	@ApiModelProperty(value = "消费卡总数", dataType = "int", example = "1")
	private Integer cardSum;
	@ApiModelProperty(value = "昨天收益", dataType = "double", example = "11.10")
	private BigDecimal yesterdayIncome;
	@ApiModelProperty(value = "今日收益", dataType = "double", example = "11.10")
	private BigDecimal todayIncome;
	@ApiModelProperty(value = "本月收益", dataType = "double", example = "11.10")
	private BigDecimal monthIncome;
	@ApiModelProperty(value = "消费卡冻结余额", dataType = "double", example = "11.10")
	private Long cardFrozen;
	@ApiModelProperty(value = "绑定的银行卡数量", dataType = "int", example = "0")
	private int cardCount;

	@ApiModelProperty(value = "总资产", dataType = "double", example = "0.00")
	private BigDecimal assetSum = BigDecimal.ZERO;

	public BigDecimal getAssetSum() {
		return assetSum;
	}

	public void setAssetSum(BigDecimal assetSum) {
		this.assetSum = assetSum;
	}

	public int getCardCount() { return cardCount; }

	public void setCardCount(int cardCount) { this.cardCount = cardCount; }

	@JsonGetter(value="cardResidue")
	public Double cardResidueFormat() {
		if(cardResidue == null ) return 0D;
		return new Double(this.cardResidue)/100;
	}

	@JsonGetter(value="cardFrozen")
	public Double cardFrozenFormat() {
		if(cardFrozen == null ) return 0D;
		return new Double(this.cardFrozen)/100;
	}
	
	public Long getCardResidue() {
		return cardResidue;
	}
	public void setCardResidue(Long cardResidue) {
		this.cardResidue = cardResidue;
	}
	public Integer getCardSum() {
		return cardSum;
	}
	public void setCardSum(Integer cardSum) {
		this.cardSum = cardSum;
	}

	public BigDecimal getYesterdayIncome() {
		return yesterdayIncome;
	}

	public void setYesterdayIncome(BigDecimal yesterdayIncome) {
		this.yesterdayIncome = yesterdayIncome;
	}

	public BigDecimal getMonthIncome() {
		return monthIncome;
	}

	public void setMonthIncome(BigDecimal monthIncome) {
		this.monthIncome = monthIncome;
	}

	public BigDecimal getTodayIncome() {
		return todayIncome;
	}

	public void setTodayIncome(BigDecimal todayIncome) {
		this.todayIncome = todayIncome;
	}

	public Long getCardFrozen() {
		return cardFrozen;
	}

	public void setCardFrozen(Long cardFrozen) {
		this.cardFrozen = cardFrozen;
	}
}
